/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.csa.rewrite.trade.functions.InterestRateLeg1Basis;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg1CrossCurrencyDefault.class)
public abstract class InterestRateLeg1CrossCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg1Basis interestRateLeg1Basis;
    @Inject
    protected drr.regulation.common.functions.InterestRateLeg1CrossCurrency interestRateLeg1CrossCurrency;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg1;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = this.doEvaluate(product);
        if (interestRateLeg1Builder == null) {
            interestRateLeg1 = null;
        } else {
            interestRateLeg1 = interestRateLeg1Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg1);
        }
        return interestRateLeg1;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product var1);

    protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg1Basis(Product var1);

    protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg1CrossCurrency(Product var1);

    public static class InterestRateLeg1CrossCurrencyDefault
    extends InterestRateLeg1CrossCurrency {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg1, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
            interestRateLeg1 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.floatingRateLegs(product).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.fixedRateLegs(product).get()) : (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.floatingRateLegs(product).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.csaInterestRateLeg1Basis(product).get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.drrInterestRateLeg1CrossCurrency(product).get()));
            return Optional.ofNullable(interestRateLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
            return this.interestRatePayouts(product).filterItemNullSafe(leg -> ExpressionOperators.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
            return this.interestRatePayouts(product).filterItemNullSafe(leg -> ExpressionOperators.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
        }

        @Override
        protected MapperS<? extends InterestRatePayout> csaInterestRateLeg1Basis(Product product) {
            return MapperS.of((Object)this.interestRateLeg1Basis.evaluate(product));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> drrInterestRateLeg1CrossCurrency(Product product) {
            return MapperS.of((Object)this.interestRateLeg1CrossCurrency.evaluate(product));
        }
    }
}

