/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.ExchangeRateRule exchangeRateRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateRuleDefault
    extends ExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            output = (BigDecimal)MapperS.of((Object)this.exchangeRateRule.evaluate((TransactionReportInstruction)thenArg.get())).get();
            return output;
        }
    }
}

