/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbUnderlyingAssetTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0070_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0070_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0070_01";
    public static final String DEFINITION = "(if (nonReportable -> postUpiData -> Header -> AssetClass = Rates or dtccAdditionalFields -> primaryAssetClass = InterestRate) then (if (nonReportable -> postUpiData -> Header -> InstrumentType = Swap or nonReportable -> instrumentType = Swap) and ((nonReportable -> postUpiData -> Derived -> UnderlyingAssetType exists and nonReportable -> postUpiData -> Derived -> UnderlyingAssetType <> Fixed_Fixed) or nonReportable -> underlyingAssetType <> \"Fixed_Fixed\") then leg1 -> periodicPayment -> floatingRateResetFrequencyPeriod exists or leg2 -> periodicPayment -> floatingRateResetFrequencyPeriod exists else leg1 -> periodicPayment -> floatingRateResetFrequencyPeriod is absent and leg2 -> periodicPayment -> floatingRateResetFrequencyPeriod is absent)) and ((if leg1 -> periodicPayment -> floatingRateResetFrequencyPeriod = EXPI then leg1 -> periodicPayment -> floatingRateResetFrequencyMultiplier = 1) and (if leg2 -> periodicPayment -> floatingRateResetFrequencyPeriod = EXPI then leg2 -> periodicPayment -> floatingRateResetFrequencyMultiplier = 1))";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0070_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0070_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0070_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0070_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0070_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0070_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                ComparisonResult ifThenElseResult2 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.RATES)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.SWAP)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getUnderlyingAssetType", annaDsbDerived -> annaDsbDerived.getUnderlyingAssetType())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getUnderlyingAssetType", annaDsbDerived -> annaDsbDerived.getUnderlyingAssetType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbUnderlyingAssetTypeEnum.FIXED_FIXED)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getUnderlyingAssetType", cSANonReportable -> cSANonReportable.getUnderlyingAssetType()), (Mapper)MapperS.of((Object)"Fixed_Fixed"), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()))) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod())))) : ComparisonResult.successEmptyOperand((String)"");
                ComparisonResult ifThenElseResult0 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.successEmptyOperand((String)"");
                ComparisonResult ifThenElseResult1 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.successEmptyOperand((String)"");
                return ifThenElseResult2.and(ifThenElseResult0.and(ifThenElseResult1));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

