/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportDTCC_CSA_VR_0023_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportDTCC_CSA_VR_0023_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportDTCC_CSA_VR_0023_01";
    public static final String DEFINITION = "if actionType = TERM and ([EventTypeEnum -> CLRG, EventTypeEnum -> CLAL] any = eventType) and centralCounterparty exists then platformAnonymousExecutionIndicator exists";

    public static class NoOp
    implements CSATransactionReportDTCC_CSA_VR_0023_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportDTCC_CSA_VR_0023_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportDTCC_CSA_VR_0023_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0023_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportDTCC_CSA_VR_0023_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0023_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getActionType", _cSATransactionReport -> _cSATransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.CLRG)), MapperS.of((Object)((Object)EventTypeEnum.CLAL))}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getEventType", _cSATransactionReport -> _cSATransactionReport.getEventType()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getCentralCounterparty", _cSATransactionReport -> _cSATransactionReport.getCentralCounterparty()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getPlatformAnonymousExecutionIndicator", _cSATransactionReport -> _cSATransactionReport.getPlatformAnonymousExecutionIndicator()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

