/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetExecutionTimestamp;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.regulation.esma.emir.refit.trade.functions.GetMicDataForFacility;
import drr.regulation.esma.emir.refit.trade.functions.IsEmirTradingVenue;
import drr.regulation.esma.emir.refit.trade.functions.IsSI;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=EMIR_VenueDefault.class)
public abstract class EMIR_Venue
implements RosettaFunction {
    @Inject
    protected GetExecutionTimestamp getExecutionTimestamp;
    @Inject
    protected GetIsin getIsin;
    @Inject
    protected GetMicDataForFacility getMicDataForFacility;
    @Inject
    protected GetTransactionInformationForRegime getTransactionInformationForRegime;
    @Inject
    protected IsEmirTradingVenue isEmirTradingVenue;
    @Inject
    protected IsSI isSI;
    @Inject
    protected ProductForEvent productForEvent;

    public String evaluate(ReportableEvent reportableEvent) {
        String venue = this.doEvaluate(reportableEvent);
        return venue;
    }

    protected abstract String doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends MicData> micDataForFacility(ReportableEvent var1);

    protected abstract MapperS<String> venueMic(ReportableEvent var1);

    protected abstract MapperS<Boolean> transactionHasIsin(ReportableEvent var1);

    protected abstract MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent var1);

    protected abstract MapperS<Boolean> isinTotv(ReportableEvent var1);

    protected abstract MapperS<Boolean> uIsinTotv(ReportableEvent var1);

    protected abstract MapperS<String> transactionValidMic(ReportableEvent var1);

    public static class EMIR_VenueDefault
    extends EMIR_Venue {
        @Override
        protected String doEvaluate(ReportableEvent reportableEvent) {
            String venue = null;
            return this.assignOutput(venue, reportableEvent);
        }

        protected String assignOutput(String venue, ReportableEvent reportableEvent) {
            venue = ExpressionOperators.exists(this.transactionValidMic(reportableEvent)).getOrDefault(Boolean.valueOf(false)) != false ? (String)this.transactionValidMic(reportableEvent).get() : ((Boolean)this.isinTotv(reportableEvent).getOrDefault((Object)false) != false ? "XOFF" : "XXXX");
            return venue;
        }

        @Override
        protected MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.getMicDataForFacility.evaluate((ReportableInformation)MapperS.of((Object)reportableEvent).map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get()));
        }

        @Override
        protected MapperS<String> venueMic(ReportableEvent reportableEvent) {
            MapperS<? extends MicData> thenArg = this.micDataForFacility(reportableEvent);
            return thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThanEquals((Mapper)item.map("getExpiryDate", micData -> micData.getExpiryDate()), (Mapper)MapperS.of((Object)this.getExecutionTimestamp.evaluate(reportableEvent)).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.notEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)item.map("getMicType", micData -> micData.getMicType()), (Mapper)MapperS.of((Object)((Object)MicTypeEnum.SGMT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getMic", micData -> micData.getMic());
                    }
                    return item.map("getOperatingMic", micData -> micData.getOperatingMic());
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<Boolean> transactionHasIsin(ReportableEvent reportableEvent) {
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)this.getIsin.evaluate(this.productForEvent.evaluate(reportableEvent)))).asMapper();
        }

        @Override
        protected MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(reportableEvent, RegimeNameEnum.EMIR, SupervisoryBodyEnum.ESMA));
        }

        @Override
        protected MapperS<Boolean> isinTotv(ReportableEvent reportableEvent) {
            return MapperS.of((Object)ExpressionOperators.areEqual((Mapper)this.transactionInformation(reportableEvent).map("getEsmaTransactionInformation", _transactionInformation -> _transactionInformation.getEsmaTransactionInformation()).map("getTradableOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
        }

        @Override
        protected MapperS<Boolean> uIsinTotv(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((Boolean)this.transactionInformation(reportableEvent).map("getEsmaTransactionInformation", _transactionInformation -> _transactionInformation.getEsmaTransactionInformation()).map("getUnderlierTradedOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getUnderlierTradedOnTradingVenue()).getOrDefault((Object)false)));
        }

        @Override
        protected MapperS<String> transactionValidMic(ReportableEvent reportableEvent) {
            if (ExpressionOperators.exists(this.venueMic(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                Boolean boolean0 = this.isEmirTradingVenue.evaluate((MicData)this.micDataForFacility(reportableEvent).get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return this.venueMic(reportableEvent);
                }
                Boolean boolean1 = this.isSI.evaluate((MicData)this.micDataForFacility(reportableEvent).get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    if (ComparisonResult.of(this.isinTotv(reportableEvent)).or(ComparisonResult.of(this.uIsinTotv(reportableEvent))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return this.venueMic(reportableEvent);
                    }
                    return MapperS.of((Object)"XXXX");
                }
                return this.venueMic(reportableEvent);
            }
            return MapperS.ofNull();
        }
    }
}

