/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.eic.functions.IsAcceptedEicCode;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2127_01")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2127_01
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2127_01";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then deliveryReport extract dr [ if IsAcceptedEicCode(deliveryPoint) or IsAcceptedEicCode(interconnectionPoint) then [\"WDAY\", \"WEND\", \"MOND\", \"TUED\", \"WEDD\", \"THUD\", \"FRID\", \"SATD\", \"SUND\", \"XBHL\", \"IBHL\"] = dr -> daysOfTheWeek else dr -> daysOfTheWeek is absent ] then all = True";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2127_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2127_01 {
        @Inject
        protected IsAcceptedEicCode isAcceptedEicCode;
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2127_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2127_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2127_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2127_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()));
                MapperC thenArg = _boolean != null && _boolean != false ? MapperS.of((Object)eSMAEMIRTransactionReport).mapC("getDeliveryReport", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryReport()).mapItem(dr -> {
                    if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isAcceptedEicCode.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).mapC("getDeliveryPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryPoint()).getMulti()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isAcceptedEicCode.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getInterconnectionPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getInterconnectionPoint()).getMulti())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)"WDAY"), MapperS.of((Object)"WEND"), MapperS.of((Object)"MOND"), MapperS.of((Object)"TUED"), MapperS.of((Object)"WEDD"), MapperS.of((Object)"THUD"), MapperS.of((Object)"FRID"), MapperS.of((Object)"SATD"), MapperS.of((Object)"SUND"), MapperS.of((Object)"XBHL"), MapperS.of((Object)"IBHL")}), (Mapper)dr.mapC("getDaysOfTheWeek", reportableDelivery -> reportableDelivery.getDaysOfTheWeek()), (CardinalityOperator)CardinalityOperator.All).asMapper();
                    }
                    return ExpressionOperators.notExists((Mapper)dr.mapC("getDaysOfTheWeek", reportableDelivery -> reportableDelivery.getDaysOfTheWeek())).asMapper();
                }) : MapperC.ofNull();
                return ComparisonResult.of((Mapper)ExpressionOperators.areEqual((Mapper)thenArg, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper());
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

