/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.util.string.functions.StringLength;
import drr.enrichment.lei.functions.GetOrFetchLeiData;
import drr.enrichment.lei.functions.LeiRegistrationStatusIsValid;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.common.functions.IsValidRefEntity;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2144_02")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2144_02
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2144_02";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then if referenceEntity exists then if GetOrFetchLeiData(empty, referenceEntity) exists then LeiRegistrationStatusIsValid( nonReportable -> enrichment -> leiData, referenceEntity, eventDate, reportingTimestamp -> date ) else if StringLength(referenceEntity) < 7 and IsValidRefEntity( referenceEntity ) = True then True else False";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2144_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2144_02 {
        @Inject
        protected GetOrFetchLeiData getOrFetchLeiData;
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;
        @Inject
        protected IsValidRefEntity isValidRefEntity;
        @Inject
        protected LeiRegistrationStatusIsValid leiRegistrationStatusIsValid;
        @Inject
        protected StringLength stringLength;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2144_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2144_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2144_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2144_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReferenceEntity", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReferenceEntity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.getOrFetchLeiData.evaluate(Collections.emptyList(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReferenceEntity", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReferenceEntity()).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return ComparisonResult.of((Mapper)MapperS.of((Object)this.leiRegistrationStatusIsValid.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReferenceEntity", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReferenceEntity()).get(), (Date)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEventDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEventDate()).get(), (Date)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReportingTimestamp", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportingTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get())));
                        }
                        if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReferenceEntity", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReferenceEntity()).get())), (Mapper)MapperS.of((Object)7), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isValidRefEntity.evaluate((String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReferenceEntity", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReferenceEntity()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return ComparisonResult.of((Mapper)MapperS.of((Object)true));
                        }
                        return ComparisonResult.of((Mapper)MapperS.of((Object)false));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

