/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2153_02")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2153_02
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2153_02";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> POSC] any = actionType then eventDate = executionTimestamp -> date else eventDate >= executionTimestamp -> date";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2153_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2153_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2153_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2153_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2153_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2153_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.POSC))}), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEventDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEventDate()), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getExecutionTimestamp", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExecutionTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All);
                }
                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEventDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEventDate()), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getExecutionTimestamp", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExecutionTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

