/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.functions.Counterparty1_02_Validation;
import drr.regulation.esma.emir.refit.valuation.ESMAValuationReport;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAValuationReportEMIR_VR_1004_02")
@ImplementedBy(value=Default.class)
public interface ESMAValuationReportEMIR_VR_1004_02
extends Validator<ESMAValuationReport> {
    public static final String NAME = "ESMAValuationReportEMIR_VR_1004_02";
    public static final String DEFINITION = "Counterparty1_02_Validation( nonReportable -> enrichment, counterparty1, eventDate, reportingTimestamp )";

    public static class NoOp
    implements ESMAValuationReportEMIR_VR_1004_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAValuationReportEMIR_VR_1004_02 {
        @Inject
        protected Counterparty1_02_Validation counterparty1_02_Validation;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            ComparisonResult result = this.executeDataRule(eSMAValuationReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAValuationReportEMIR_VR_1004_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_1004_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAValuationReportEMIR_VR_1004_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_1004_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAValuationReport eSMAValuationReport) {
            try {
                return ComparisonResult.of((Mapper)MapperS.of((Object)this.counterparty1_02_Validation.evaluate((EnrichmentData)MapperS.of((Object)eSMAValuationReport).map("getNonReportable", _eSMAValuationReport -> _eSMAValuationReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).get(), (String)MapperS.of((Object)eSMAValuationReport).map("getCounterparty1", _eSMAValuationReport -> _eSMAValuationReport.getCounterparty1()).get(), (Date)MapperS.of((Object)eSMAValuationReport).map("getEventDate", _eSMAValuationReport -> _eSMAValuationReport.getEventDate()).get(), (ZonedDateTime)MapperS.of((Object)eSMAValuationReport).map("getReportingTimestamp", _eSMAValuationReport -> _eSMAValuationReport.getReportingTimestamp()).get())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

