/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.functions.GetVenueOfExecution;
import drr.standards.iso.MicData;
import drr.standards.iso.functions.GetOrFetchMicData;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetMicDataForFacilityDefault.class)
public abstract class GetMicDataForFacility
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetOrFetchMicData getOrFetchMicData;
    @Inject
    protected GetVenueOfExecution getVenueOfExecution;

    public MicData evaluate(ReportableInformation reportableInformation) {
        MicData micData;
        MicData.MicDataBuilder micDataBuilder = this.doEvaluate(reportableInformation);
        if (micDataBuilder == null) {
            micData = null;
        } else {
            micData = micDataBuilder.build();
            this.objectValidator.validate(MicData.class, (RosettaModelObject)micData);
        }
        return micData;
    }

    protected abstract MicData.MicDataBuilder doEvaluate(ReportableInformation var1);

    protected abstract MapperS<String> executionFacility(ReportableInformation var1);

    public static class GetMicDataForFacilityDefault
    extends GetMicDataForFacility {
        @Override
        protected MicData.MicDataBuilder doEvaluate(ReportableInformation reportableInformation) {
            MicData.MicDataBuilder micData = MicData.builder();
            return this.assignOutput(micData, reportableInformation);
        }

        protected MicData.MicDataBuilder assignOutput(MicData.MicDataBuilder micData, ReportableInformation reportableInformation) {
            micData = (MicData.MicDataBuilder)this.toBuilder(this.getOrFetchMicData.evaluate(MapperS.of((Object)reportableInformation).map("getEnrichment", _reportableInformation -> _reportableInformation.getEnrichment()).mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), (String)this.executionFacility(reportableInformation).get()));
            return Optional.ofNullable(micData).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<String> executionFacility(ReportableInformation reportableInformation) {
            return MapperS.of((Object)this.getVenueOfExecution.evaluate(reportableInformation));
        }
    }
}

