/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.fca.ukemir.refit.trade.reports.PackageTransactionPriceNotationRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceValueRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceRuleDefault.class)
public abstract class PackageTransactionPriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PackageTransactionPriceValueRule packageTransactionPriceValueRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceRuleDefault
    extends PackageTransactionPriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.packageTransactionPriceValueRule.evaluate((TransactionReportInstruction)item.get()), this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get())))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

