/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import javax.inject.Inject;

@ImplementedBy(value=TrancheRuleDefault.class)
public abstract class TrancheRule
implements ReportFunction<TransactionReportInstruction, Boolean> {
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected TradeForEvent tradeForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Boolean evaluate(TransactionReportInstruction input) {
        Boolean output = this.doEvaluate(input);
        return output;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    public static class TrancheRuleDefault
    extends TrancheRule {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction input) {
            Boolean output = null;
            return this.assignOutput(output, input);
        }

        protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate(this.tradeForEvent.evaluate((ReportableEventBase)item.get()))));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.isCreditSwaption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.underlierForProduct.evaluate((Product)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                Boolean boolean1 = this.isCreditDefaultSwap.evaluate((Product)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                return MapperS.ofNull();
            });
            output = (Boolean)thenArg2.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getTranche", creditIndexReferenceInformation -> creditIndexReferenceInformation.getTranche())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                if (ExpressionOperators.exists((Mapper)item.map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getTranche", basketReferenceInformation -> basketReferenceInformation.getTranche())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                return MapperS.of((Object)false);
            }).get();
            return output;
        }
    }
}

