/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.margin.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HKMAMarginReportTypeFormatValidator
implements Validator<HKMAMarginReport> {
    private List<ComparisonResult> getComparisonResults(HKMAMarginReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"counterparty2Name", (String)o.getCounterparty2Name(), (int)1, Optional.of(105), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,105}"))), ExpressionOperators.checkNumber((String)"initialMarginPostedByTheReportingCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginPostedByTheReportingCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByTheReportingCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByTheReportingCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginPostedByTheReportingCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginPostedByTheReportingCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginCollectedByTheReportingCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginCollectedByTheReportingCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"excessCollateralPostedByTheCounterparty1", (BigDecimal)o.getExcessCollateralPostedByTheCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"excessCollateralCollectedByTheCounterparty1", (BigDecimal)o.getExcessCollateralCollectedByTheCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"entityResponsibleForReporting", (String)o.getEntityResponsibleForReporting(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkNumber((String)"numberRecords", (BigDecimal)o.getNumberRecords(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAMarginReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"HKMAMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMAMarginReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"HKMAMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMAMarginReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

