/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.base.util.party.PartyIdentifierFormat2Enum;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.HKTRPartyScheme;
import drr.regulation.common.ReferenceEntityFormatEnum;
import drr.regulation.common.UTIProprietarySchemeNameEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.hkma.rewrite.trade.meta.HKMATransactionReportMeta;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="HKMATransactionReport", builder=HKMATransactionReportBuilderImpl.class, version="7.0.0-dev.17")
@RuneDataType(value="HKMATransactionReport", model="drr", builder=HKMATransactionReportBuilderImpl.class, version="7.0.0-dev.17")
public interface HKMATransactionReport
extends CommonTransactionReport {
    public static final HKMATransactionReportMeta metaData = new HKMATransactionReportMeta();

    @Override
    public String getTechnicalRecordId();

    @Override
    public ZonedDateTime getEventTimestamp();

    @Override
    public CommonContractType getContractType();

    @Override
    public CommonAssetClass getAssetClass();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public String getVariationMarginCollateralPortfolioCode();

    @Override
    public String getEntityResponsibleForReporting();

    @Override
    public NatureOfCounterpartyEnum getNatureOfCounterparty1();

    public List<BigDecimal> getBasketConstituentNumberOfUnits();

    public List<String> getBasketConstituentUnitOfMeasure();

    public String getProductDescription();

    public String getBeneficiary();

    public String getRemarks();

    public String getRemarks1();

    public String getRemarks2();

    public String getRemarks3();

    public String getRemarks4();

    public String getRemarks5();

    public String getRemarks6();

    public String getRemarks7();

    public String getRemarks8();

    public String getRemarks9();

    public String getRemarks10();

    public String getRemarks11();

    public String getRemarks12();

    public String getRemarks13();

    public String getUniqueProductIdentifierProprietary();

    public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

    public HKTRPartyScheme getCounterparty2SchemeName();

    public PartyIdentifierFormat2Enum getCentralCounterpartyIdentifierFormat();

    public HKTRPartyScheme getCentralCounterpartySchemeName();

    public PartyIdentifierFormat2Enum getBrokerIdentifierFormat();

    public HKTRPartyScheme getBrokerSchemeName();

    public ReferenceEntityFormatEnum getReferenceEntityFormat();

    public PartyIdentifierFormat2Enum getClearingMemberIdentifierFormat();

    public HKTRPartyScheme getClearingMemberSchemeName();

    public UTIProprietarySchemeNameEnum getPriorUTIProprietarySchemeName();

    public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName();

    @Override
    public HKMATransactionReport build();

    @Override
    public HKMATransactionReportBuilder toBuilder();

    public static HKMATransactionReportBuilder builder() {
        return new HKMATransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends HKMATransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends HKMATransactionReport> getType() {
        return HKMATransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basketConstituentNumberOfUnits"), BigDecimal.class, this.getBasketConstituentNumberOfUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basketConstituentUnitOfMeasure"), String.class, this.getBasketConstituentUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productDescription"), String.class, (Object)this.getProductDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary"), String.class, (Object)this.getBeneficiary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks1"), String.class, (Object)this.getRemarks1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks2"), String.class, (Object)this.getRemarks2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks3"), String.class, (Object)this.getRemarks3(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks4"), String.class, (Object)this.getRemarks4(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks5"), String.class, (Object)this.getRemarks5(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks6"), String.class, (Object)this.getRemarks6(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks7"), String.class, (Object)this.getRemarks7(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks8"), String.class, (Object)this.getRemarks8(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks9"), String.class, (Object)this.getRemarks9(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks10"), String.class, (Object)this.getRemarks10(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks11"), String.class, (Object)this.getRemarks11(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks12"), String.class, (Object)this.getRemarks12(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks13"), String.class, (Object)this.getRemarks13(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifierProprietary"), String.class, (Object)this.getUniqueProductIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterpartyIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCentralCounterpartyIdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterpartySchemeName"), HKTRPartyScheme.class, (Object)this.getCentralCounterpartySchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getBrokerIdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerSchemeName"), HKTRPartyScheme.class, (Object)this.getBrokerSchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntityFormat"), ReferenceEntityFormatEnum.class, (Object)this.getReferenceEntityFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMemberIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getClearingMemberIdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMemberSchemeName"), HKTRPartyScheme.class, (Object)this.getClearingMemberSchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getPriorUTIProprietarySchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class HKMATransactionReportBuilderImpl
    extends CommonTransactionReport.CommonTransactionReportBuilderImpl
    implements HKMATransactionReportBuilder {
        protected String technicalRecordId;
        protected ZonedDateTime eventTimestamp;
        protected CommonContractType contractType;
        protected CommonAssetClass assetClass;
        protected Boolean counterparty2IdentifierType;
        protected String variationMarginCollateralPortfolioCode;
        protected String entityResponsibleForReporting;
        protected NatureOfCounterpartyEnum natureOfCounterparty1;
        protected List<BigDecimal> basketConstituentNumberOfUnits = new ArrayList<BigDecimal>();
        protected List<String> basketConstituentUnitOfMeasure = new ArrayList<String>();
        protected String productDescription;
        protected String beneficiary;
        protected String remarks;
        protected String remarks1;
        protected String remarks2;
        protected String remarks3;
        protected String remarks4;
        protected String remarks5;
        protected String remarks6;
        protected String remarks7;
        protected String remarks8;
        protected String remarks9;
        protected String remarks10;
        protected String remarks11;
        protected String remarks12;
        protected String remarks13;
        protected String uniqueProductIdentifierProprietary;
        protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        protected HKTRPartyScheme counterparty2SchemeName;
        protected PartyIdentifierFormat2Enum centralCounterpartyIdentifierFormat;
        protected HKTRPartyScheme centralCounterpartySchemeName;
        protected PartyIdentifierFormat2Enum brokerIdentifierFormat;
        protected HKTRPartyScheme brokerSchemeName;
        protected ReferenceEntityFormatEnum referenceEntityFormat;
        protected PartyIdentifierFormat2Enum clearingMemberIdentifierFormat;
        protected HKTRPartyScheme clearingMemberSchemeName;
        protected UTIProprietarySchemeNameEnum priorUTIProprietarySchemeName;
        protected UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
            return this.natureOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="basketConstituentNumberOfUnits")
        @RuneAttribute(value="basketConstituentNumberOfUnits")
        public List<BigDecimal> getBasketConstituentNumberOfUnits() {
            return this.basketConstituentNumberOfUnits;
        }

        @Override
        @RosettaAttribute(value="basketConstituentUnitOfMeasure")
        @RuneAttribute(value="basketConstituentUnitOfMeasure")
        public List<String> getBasketConstituentUnitOfMeasure() {
            return this.basketConstituentUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="productDescription")
        @RuneAttribute(value="productDescription")
        public String getProductDescription() {
            return this.productDescription;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public String getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="remarks1")
        @RuneAttribute(value="remarks1")
        public String getRemarks1() {
            return this.remarks1;
        }

        @Override
        @RosettaAttribute(value="remarks2")
        @RuneAttribute(value="remarks2")
        public String getRemarks2() {
            return this.remarks2;
        }

        @Override
        @RosettaAttribute(value="remarks3")
        @RuneAttribute(value="remarks3")
        public String getRemarks3() {
            return this.remarks3;
        }

        @Override
        @RosettaAttribute(value="remarks4")
        @RuneAttribute(value="remarks4")
        public String getRemarks4() {
            return this.remarks4;
        }

        @Override
        @RosettaAttribute(value="remarks5")
        @RuneAttribute(value="remarks5")
        public String getRemarks5() {
            return this.remarks5;
        }

        @Override
        @RosettaAttribute(value="remarks6")
        @RuneAttribute(value="remarks6")
        public String getRemarks6() {
            return this.remarks6;
        }

        @Override
        @RosettaAttribute(value="remarks7")
        @RuneAttribute(value="remarks7")
        public String getRemarks7() {
            return this.remarks7;
        }

        @Override
        @RosettaAttribute(value="remarks8")
        @RuneAttribute(value="remarks8")
        public String getRemarks8() {
            return this.remarks8;
        }

        @Override
        @RosettaAttribute(value="remarks9")
        @RuneAttribute(value="remarks9")
        public String getRemarks9() {
            return this.remarks9;
        }

        @Override
        @RosettaAttribute(value="remarks10")
        @RuneAttribute(value="remarks10")
        public String getRemarks10() {
            return this.remarks10;
        }

        @Override
        @RosettaAttribute(value="remarks11")
        @RuneAttribute(value="remarks11")
        public String getRemarks11() {
            return this.remarks11;
        }

        @Override
        @RosettaAttribute(value="remarks12")
        @RuneAttribute(value="remarks12")
        public String getRemarks12() {
            return this.remarks12;
        }

        @Override
        @RosettaAttribute(value="remarks13")
        @RuneAttribute(value="remarks13")
        public String getRemarks13() {
            return this.remarks13;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifierProprietary")
        @RuneAttribute(value="uniqueProductIdentifierProprietary")
        public String getUniqueProductIdentifierProprietary() {
            return this.uniqueProductIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartyIdentifierFormat")
        @RuneAttribute(value="centralCounterpartyIdentifierFormat")
        public PartyIdentifierFormat2Enum getCentralCounterpartyIdentifierFormat() {
            return this.centralCounterpartyIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartySchemeName")
        @RuneAttribute(value="centralCounterpartySchemeName")
        public HKTRPartyScheme getCentralCounterpartySchemeName() {
            return this.centralCounterpartySchemeName;
        }

        @Override
        @RosettaAttribute(value="brokerIdentifierFormat")
        @RuneAttribute(value="brokerIdentifierFormat")
        public PartyIdentifierFormat2Enum getBrokerIdentifierFormat() {
            return this.brokerIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="brokerSchemeName")
        @RuneAttribute(value="brokerSchemeName")
        public HKTRPartyScheme getBrokerSchemeName() {
            return this.brokerSchemeName;
        }

        @Override
        @RosettaAttribute(value="referenceEntityFormat")
        @RuneAttribute(value="referenceEntityFormat")
        public ReferenceEntityFormatEnum getReferenceEntityFormat() {
            return this.referenceEntityFormat;
        }

        @Override
        @RosettaAttribute(value="clearingMemberIdentifierFormat")
        @RuneAttribute(value="clearingMemberIdentifierFormat")
        public PartyIdentifierFormat2Enum getClearingMemberIdentifierFormat() {
            return this.clearingMemberIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="clearingMemberSchemeName")
        @RuneAttribute(value="clearingMemberSchemeName")
        public HKTRPartyScheme getClearingMemberSchemeName() {
            return this.clearingMemberSchemeName;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietarySchemeName")
        @RuneAttribute(value="priorUTIProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getPriorUTIProprietarySchemeName() {
            return this.priorUTIProprietarySchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public HKMATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public HKMATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public HKMATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public HKMATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public HKMATransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public HKMATransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public HKMATransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public HKMATransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public HKMATransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public HKMATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public HKMATransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public HKMATransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public HKMATransactionReportBuilder setCleared(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public HKMATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public HKMATransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public HKMATransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public HKMATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public HKMATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public HKMATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public HKMATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public HKMATransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public HKMATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public HKMATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public HKMATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public HKMATransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public HKMATransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public HKMATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public HKMATransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public HKMATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public HKMATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public HKMATransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public HKMATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public HKMATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public HKMATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public HKMATransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public HKMATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public HKMATransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public HKMATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public HKMATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public HKMATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public HKMATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public HKMATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public HKMATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public HKMATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public HKMATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public HKMATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public HKMATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public HKMATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public HKMATransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public HKMATransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public HKMATransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public HKMATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public HKMATransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public HKMATransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public HKMATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public HKMATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public HKMATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public HKMATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public HKMATransactionReportBuilder setLeg1(CommonLeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg1(Leg _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg1(LegV2 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg1(LegV1 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public HKMATransactionReportBuilder setLeg2(CommonLeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg2(Leg _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg2(LegV2 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setLeg2(LegV1 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public HKMATransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public HKMATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public HKMATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public HKMATransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public HKMATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public HKMATransactionReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public HKMATransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public HKMATransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public HKMATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public HKMATransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public HKMATransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public HKMATransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public HKMATransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public HKMATransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public HKMATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public HKMATransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public HKMATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public HKMATransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setContractType(CommonContractType _contractType) {
            return this.setContractTypeOverriddenAsCommonContractType(_contractType);
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public HKMATransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            return this.setAssetClassOverriddenAsCommonAssetClass(_assetClass);
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public HKMATransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public HKMATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public HKMATransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public HKMATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public HKMATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public HKMATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public HKMATransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public HKMATransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public HKMATransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public HKMATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public HKMATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public HKMATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public HKMATransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public HKMATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public HKMATransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public HKMATransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public HKMATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public HKMATransactionReportBuilder setTechnicalRecordIdOverriddenAsString(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            return this.setTechnicalRecordIdOverriddenAsString(_technicalRecordId);
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public HKMATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public HKMATransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public HKMATransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public HKMATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public HKMATransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public HKMATransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public HKMATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            return this.setVariationMarginCollateralPortfolioCodeOverriddenAsString(_variationMarginCollateralPortfolioCode);
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public HKMATransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType")
        @RuneAttribute(value="masterAgreementType")
        public HKMATransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public HKMATransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public HKMATransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public HKMATransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public HKMATransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public HKMATransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public HKMATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public HKMATransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public HKMATransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public HKMATransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            return this.setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(_natureOfCounterparty1);
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public HKMATransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public HKMATransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public HKMATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public HKMATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public HKMATransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public HKMATransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public HKMATransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public HKMATransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public HKMATransactionReportBuilder setEntityResponsibleForReportingOverriddenAsString(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaIgnore
        public HKMATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            return this.setEntityResponsibleForReportingOverriddenAsString(_entityResponsibleForReporting);
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public HKMATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public HKMATransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public HKMATransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public HKMATransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public HKMATransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public HKMATransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public HKMATransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public HKMATransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituentNumberOfUnits")
        @RuneAttribute(value="basketConstituentNumberOfUnits")
        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal _basketConstituentNumberOfUnits) {
            if (_basketConstituentNumberOfUnits != null) {
                this.basketConstituentNumberOfUnits.add(_basketConstituentNumberOfUnits);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal _basketConstituentNumberOfUnits, int idx) {
            this.getIndex(this.basketConstituentNumberOfUnits, idx, () -> _basketConstituentNumberOfUnits);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnitss) {
            if (basketConstituentNumberOfUnitss != null) {
                for (BigDecimal toAdd : basketConstituentNumberOfUnitss) {
                    this.basketConstituentNumberOfUnits.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituentNumberOfUnits")
        public HKMATransactionReportBuilder setBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnitss) {
            this.basketConstituentNumberOfUnits = basketConstituentNumberOfUnitss == null ? new ArrayList<BigDecimal>() : (List)basketConstituentNumberOfUnitss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituentUnitOfMeasure")
        @RuneAttribute(value="basketConstituentUnitOfMeasure")
        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String _basketConstituentUnitOfMeasure) {
            if (_basketConstituentUnitOfMeasure != null) {
                this.basketConstituentUnitOfMeasure.add(_basketConstituentUnitOfMeasure);
            }
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String _basketConstituentUnitOfMeasure, int idx) {
            this.getIndex(this.basketConstituentUnitOfMeasure, idx, () -> _basketConstituentUnitOfMeasure);
            return this;
        }

        @Override
        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasures) {
            if (basketConstituentUnitOfMeasures != null) {
                for (String toAdd : basketConstituentUnitOfMeasures) {
                    this.basketConstituentUnitOfMeasure.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituentUnitOfMeasure")
        public HKMATransactionReportBuilder setBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasures) {
            this.basketConstituentUnitOfMeasure = basketConstituentUnitOfMeasures == null ? new ArrayList<String>() : (List)basketConstituentUnitOfMeasures.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productDescription")
        @RuneAttribute(value="productDescription")
        public HKMATransactionReportBuilder setProductDescription(String _productDescription) {
            this.productDescription = _productDescription == null ? null : _productDescription;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public HKMATransactionReportBuilder setBeneficiary(String _beneficiary) {
            this.beneficiary = _beneficiary == null ? null : _beneficiary;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public HKMATransactionReportBuilder setRemarks(String _remarks) {
            this.remarks = _remarks == null ? null : _remarks;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks1")
        @RuneAttribute(value="remarks1")
        public HKMATransactionReportBuilder setRemarks1(String _remarks1) {
            this.remarks1 = _remarks1 == null ? null : _remarks1;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks2")
        @RuneAttribute(value="remarks2")
        public HKMATransactionReportBuilder setRemarks2(String _remarks2) {
            this.remarks2 = _remarks2 == null ? null : _remarks2;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks3")
        @RuneAttribute(value="remarks3")
        public HKMATransactionReportBuilder setRemarks3(String _remarks3) {
            this.remarks3 = _remarks3 == null ? null : _remarks3;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks4")
        @RuneAttribute(value="remarks4")
        public HKMATransactionReportBuilder setRemarks4(String _remarks4) {
            this.remarks4 = _remarks4 == null ? null : _remarks4;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks5")
        @RuneAttribute(value="remarks5")
        public HKMATransactionReportBuilder setRemarks5(String _remarks5) {
            this.remarks5 = _remarks5 == null ? null : _remarks5;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks6")
        @RuneAttribute(value="remarks6")
        public HKMATransactionReportBuilder setRemarks6(String _remarks6) {
            this.remarks6 = _remarks6 == null ? null : _remarks6;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks7")
        @RuneAttribute(value="remarks7")
        public HKMATransactionReportBuilder setRemarks7(String _remarks7) {
            this.remarks7 = _remarks7 == null ? null : _remarks7;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks8")
        @RuneAttribute(value="remarks8")
        public HKMATransactionReportBuilder setRemarks8(String _remarks8) {
            this.remarks8 = _remarks8 == null ? null : _remarks8;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks9")
        @RuneAttribute(value="remarks9")
        public HKMATransactionReportBuilder setRemarks9(String _remarks9) {
            this.remarks9 = _remarks9 == null ? null : _remarks9;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks10")
        @RuneAttribute(value="remarks10")
        public HKMATransactionReportBuilder setRemarks10(String _remarks10) {
            this.remarks10 = _remarks10 == null ? null : _remarks10;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks11")
        @RuneAttribute(value="remarks11")
        public HKMATransactionReportBuilder setRemarks11(String _remarks11) {
            this.remarks11 = _remarks11 == null ? null : _remarks11;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks12")
        @RuneAttribute(value="remarks12")
        public HKMATransactionReportBuilder setRemarks12(String _remarks12) {
            this.remarks12 = _remarks12 == null ? null : _remarks12;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks13")
        @RuneAttribute(value="remarks13")
        public HKMATransactionReportBuilder setRemarks13(String _remarks13) {
            this.remarks13 = _remarks13 == null ? null : _remarks13;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifierProprietary")
        @RuneAttribute(value="uniqueProductIdentifierProprietary")
        public HKMATransactionReportBuilder setUniqueProductIdentifierProprietary(String _uniqueProductIdentifierProprietary) {
            this.uniqueProductIdentifierProprietary = _uniqueProductIdentifierProprietary == null ? null : _uniqueProductIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public HKMATransactionReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
            this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKMATransactionReportBuilder setCounterparty2SchemeName(HKTRPartyScheme _counterparty2SchemeName) {
            this.counterparty2SchemeName = _counterparty2SchemeName == null ? null : _counterparty2SchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartyIdentifierFormat")
        @RuneAttribute(value="centralCounterpartyIdentifierFormat")
        public HKMATransactionReportBuilder setCentralCounterpartyIdentifierFormat(PartyIdentifierFormat2Enum _centralCounterpartyIdentifierFormat) {
            this.centralCounterpartyIdentifierFormat = _centralCounterpartyIdentifierFormat == null ? null : _centralCounterpartyIdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartySchemeName")
        @RuneAttribute(value="centralCounterpartySchemeName")
        public HKMATransactionReportBuilder setCentralCounterpartySchemeName(HKTRPartyScheme _centralCounterpartySchemeName) {
            this.centralCounterpartySchemeName = _centralCounterpartySchemeName == null ? null : _centralCounterpartySchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerIdentifierFormat")
        @RuneAttribute(value="brokerIdentifierFormat")
        public HKMATransactionReportBuilder setBrokerIdentifierFormat(PartyIdentifierFormat2Enum _brokerIdentifierFormat) {
            this.brokerIdentifierFormat = _brokerIdentifierFormat == null ? null : _brokerIdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerSchemeName")
        @RuneAttribute(value="brokerSchemeName")
        public HKMATransactionReportBuilder setBrokerSchemeName(HKTRPartyScheme _brokerSchemeName) {
            this.brokerSchemeName = _brokerSchemeName == null ? null : _brokerSchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntityFormat")
        @RuneAttribute(value="referenceEntityFormat")
        public HKMATransactionReportBuilder setReferenceEntityFormat(ReferenceEntityFormatEnum _referenceEntityFormat) {
            this.referenceEntityFormat = _referenceEntityFormat == null ? null : _referenceEntityFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMemberIdentifierFormat")
        @RuneAttribute(value="clearingMemberIdentifierFormat")
        public HKMATransactionReportBuilder setClearingMemberIdentifierFormat(PartyIdentifierFormat2Enum _clearingMemberIdentifierFormat) {
            this.clearingMemberIdentifierFormat = _clearingMemberIdentifierFormat == null ? null : _clearingMemberIdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMemberSchemeName")
        @RuneAttribute(value="clearingMemberSchemeName")
        public HKMATransactionReportBuilder setClearingMemberSchemeName(HKTRPartyScheme _clearingMemberSchemeName) {
            this.clearingMemberSchemeName = _clearingMemberSchemeName == null ? null : _clearingMemberSchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietarySchemeName")
        @RuneAttribute(value="priorUTIProprietarySchemeName")
        public HKMATransactionReportBuilder setPriorUTIProprietarySchemeName(UTIProprietarySchemeNameEnum _priorUTIProprietarySchemeName) {
            this.priorUTIProprietarySchemeName = _priorUTIProprietarySchemeName == null ? null : _priorUTIProprietarySchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum _uniqueTransactionIdentifierProprietarySchemeName) {
            this.uniqueTransactionIdentifierProprietarySchemeName = _uniqueTransactionIdentifierProprietarySchemeName == null ? null : _uniqueTransactionIdentifierProprietarySchemeName;
            return this;
        }

        @Override
        public HKMATransactionReport build() {
            return new HKMATransactionReportImpl(this);
        }

        @Override
        public HKMATransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public HKMATransactionReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getNatureOfCounterparty1() != null) {
                return true;
            }
            if (this.getBasketConstituentNumberOfUnits() != null && !this.getBasketConstituentNumberOfUnits().isEmpty()) {
                return true;
            }
            if (this.getBasketConstituentUnitOfMeasure() != null && !this.getBasketConstituentUnitOfMeasure().isEmpty()) {
                return true;
            }
            if (this.getProductDescription() != null) {
                return true;
            }
            if (this.getBeneficiary() != null) {
                return true;
            }
            if (this.getRemarks() != null) {
                return true;
            }
            if (this.getRemarks1() != null) {
                return true;
            }
            if (this.getRemarks2() != null) {
                return true;
            }
            if (this.getRemarks3() != null) {
                return true;
            }
            if (this.getRemarks4() != null) {
                return true;
            }
            if (this.getRemarks5() != null) {
                return true;
            }
            if (this.getRemarks6() != null) {
                return true;
            }
            if (this.getRemarks7() != null) {
                return true;
            }
            if (this.getRemarks8() != null) {
                return true;
            }
            if (this.getRemarks9() != null) {
                return true;
            }
            if (this.getRemarks10() != null) {
                return true;
            }
            if (this.getRemarks11() != null) {
                return true;
            }
            if (this.getRemarks12() != null) {
                return true;
            }
            if (this.getRemarks13() != null) {
                return true;
            }
            if (this.getUniqueProductIdentifierProprietary() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierFormat() != null) {
                return true;
            }
            if (this.getCounterparty2SchemeName() != null) {
                return true;
            }
            if (this.getCentralCounterpartyIdentifierFormat() != null) {
                return true;
            }
            if (this.getCentralCounterpartySchemeName() != null) {
                return true;
            }
            if (this.getBrokerIdentifierFormat() != null) {
                return true;
            }
            if (this.getBrokerSchemeName() != null) {
                return true;
            }
            if (this.getReferenceEntityFormat() != null) {
                return true;
            }
            if (this.getClearingMemberIdentifierFormat() != null) {
                return true;
            }
            if (this.getClearingMemberSchemeName() != null) {
                return true;
            }
            if (this.getPriorUTIProprietarySchemeName() != null) {
                return true;
            }
            return this.getUniqueTransactionIdentifierProprietarySchemeName() != null;
        }

        @Override
        public HKMATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            HKMATransactionReportBuilder o = (HKMATransactionReportBuilder)other;
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordIdOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractTypeOverriddenAsCommonContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClassOverriddenAsCommonAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCodeOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReportingOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNatureOfCounterparty1(), (Object)o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum, new AttributeMeta[0]);
            merger.mergeBasic(this.getBasketConstituentNumberOfUnits(), o.getBasketConstituentNumberOfUnits(), this::addBasketConstituentNumberOfUnits);
            merger.mergeBasic(this.getBasketConstituentUnitOfMeasure(), o.getBasketConstituentUnitOfMeasure(), this::addBasketConstituentUnitOfMeasure);
            merger.mergeBasic((Object)this.getProductDescription(), (Object)o.getProductDescription(), this::setProductDescription, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary(), (Object)o.getBeneficiary(), this::setBeneficiary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks(), (Object)o.getRemarks(), this::setRemarks, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks1(), (Object)o.getRemarks1(), this::setRemarks1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks2(), (Object)o.getRemarks2(), this::setRemarks2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks3(), (Object)o.getRemarks3(), this::setRemarks3, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks4(), (Object)o.getRemarks4(), this::setRemarks4, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks5(), (Object)o.getRemarks5(), this::setRemarks5, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks6(), (Object)o.getRemarks6(), this::setRemarks6, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks7(), (Object)o.getRemarks7(), this::setRemarks7, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks8(), (Object)o.getRemarks8(), this::setRemarks8, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks9(), (Object)o.getRemarks9(), this::setRemarks9, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks10(), (Object)o.getRemarks10(), this::setRemarks10, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks11(), (Object)o.getRemarks11(), this::setRemarks11, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks12(), (Object)o.getRemarks12(), this::setRemarks12, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks13(), (Object)o.getRemarks13(), this::setRemarks13, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifierProprietary(), (Object)o.getUniqueProductIdentifierProprietary(), this::setUniqueProductIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierFormat(), (Object)o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2SchemeName(), (Object)o.getCounterparty2SchemeName(), this::setCounterparty2SchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterpartyIdentifierFormat(), (Object)o.getCentralCounterpartyIdentifierFormat(), this::setCentralCounterpartyIdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterpartySchemeName(), (Object)o.getCentralCounterpartySchemeName(), this::setCentralCounterpartySchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBrokerIdentifierFormat(), (Object)o.getBrokerIdentifierFormat(), this::setBrokerIdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBrokerSchemeName(), (Object)o.getBrokerSchemeName(), this::setBrokerSchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceEntityFormat(), (Object)o.getReferenceEntityFormat(), this::setReferenceEntityFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMemberIdentifierFormat(), (Object)o.getClearingMemberIdentifierFormat(), this::setClearingMemberIdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMemberSchemeName(), (Object)o.getClearingMemberSchemeName(), this::setClearingMemberSchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTIProprietarySchemeName(), (Object)o.getPriorUTIProprietarySchemeName(), this::setPriorUTIProprietarySchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (Object)o.getUniqueTransactionIdentifierProprietarySchemeName(), this::setUniqueTransactionIdentifierProprietarySchemeName, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMATransactionReport _that = (HKMATransactionReport)this.getType().cast(o);
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals((Object)this.natureOfCounterparty1, (Object)_that.getNatureOfCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituentNumberOfUnits, _that.getBasketConstituentNumberOfUnits())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituentUnitOfMeasure, _that.getBasketConstituentUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.productDescription, _that.getProductDescription())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary, _that.getBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals(this.remarks1, _that.getRemarks1())) {
                return false;
            }
            if (!Objects.equals(this.remarks2, _that.getRemarks2())) {
                return false;
            }
            if (!Objects.equals(this.remarks3, _that.getRemarks3())) {
                return false;
            }
            if (!Objects.equals(this.remarks4, _that.getRemarks4())) {
                return false;
            }
            if (!Objects.equals(this.remarks5, _that.getRemarks5())) {
                return false;
            }
            if (!Objects.equals(this.remarks6, _that.getRemarks6())) {
                return false;
            }
            if (!Objects.equals(this.remarks7, _that.getRemarks7())) {
                return false;
            }
            if (!Objects.equals(this.remarks8, _that.getRemarks8())) {
                return false;
            }
            if (!Objects.equals(this.remarks9, _that.getRemarks9())) {
                return false;
            }
            if (!Objects.equals(this.remarks10, _that.getRemarks10())) {
                return false;
            }
            if (!Objects.equals(this.remarks11, _that.getRemarks11())) {
                return false;
            }
            if (!Objects.equals(this.remarks12, _that.getRemarks12())) {
                return false;
            }
            if (!Objects.equals(this.remarks13, _that.getRemarks13())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifierProprietary, _that.getUniqueProductIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.centralCounterpartyIdentifierFormat, (Object)_that.getCentralCounterpartyIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.centralCounterpartySchemeName, (Object)_that.getCentralCounterpartySchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.brokerIdentifierFormat, (Object)_that.getBrokerIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.brokerSchemeName, (Object)_that.getBrokerSchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceEntityFormat, (Object)_that.getReferenceEntityFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingMemberIdentifierFormat, (Object)_that.getClearingMemberIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingMemberSchemeName, (Object)_that.getClearingMemberSchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.priorUTIProprietarySchemeName, (Object)_that.getPriorUTIProprietarySchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.natureOfCounterparty1 != null ? ((Object)((Object)this.natureOfCounterparty1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.basketConstituentNumberOfUnits != null ? this.basketConstituentNumberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituentUnitOfMeasure != null ? this.basketConstituentUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.productDescription != null ? this.productDescription.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.remarks1 != null ? this.remarks1.hashCode() : 0);
            _result = 31 * _result + (this.remarks2 != null ? this.remarks2.hashCode() : 0);
            _result = 31 * _result + (this.remarks3 != null ? this.remarks3.hashCode() : 0);
            _result = 31 * _result + (this.remarks4 != null ? this.remarks4.hashCode() : 0);
            _result = 31 * _result + (this.remarks5 != null ? this.remarks5.hashCode() : 0);
            _result = 31 * _result + (this.remarks6 != null ? this.remarks6.hashCode() : 0);
            _result = 31 * _result + (this.remarks7 != null ? this.remarks7.hashCode() : 0);
            _result = 31 * _result + (this.remarks8 != null ? this.remarks8.hashCode() : 0);
            _result = 31 * _result + (this.remarks9 != null ? this.remarks9.hashCode() : 0);
            _result = 31 * _result + (this.remarks10 != null ? this.remarks10.hashCode() : 0);
            _result = 31 * _result + (this.remarks11 != null ? this.remarks11.hashCode() : 0);
            _result = 31 * _result + (this.remarks12 != null ? this.remarks12.hashCode() : 0);
            _result = 31 * _result + (this.remarks13 != null ? this.remarks13.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifierProprietary != null ? this.uniqueProductIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterpartyIdentifierFormat != null ? ((Object)((Object)this.centralCounterpartyIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterpartySchemeName != null ? ((Object)((Object)this.centralCounterpartySchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.brokerIdentifierFormat != null ? ((Object)((Object)this.brokerIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.brokerSchemeName != null ? ((Object)((Object)this.brokerSchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceEntityFormat != null ? ((Object)((Object)this.referenceEntityFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingMemberIdentifierFormat != null ? ((Object)((Object)this.clearingMemberIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingMemberSchemeName != null ? ((Object)((Object)this.clearingMemberSchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTIProprietarySchemeName != null ? ((Object)((Object)this.priorUTIProprietarySchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMATransactionReportBuilder {technicalRecordId=" + this.technicalRecordId + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", natureOfCounterparty1=" + String.valueOf((Object)this.natureOfCounterparty1) + ", basketConstituentNumberOfUnits=" + String.valueOf(this.basketConstituentNumberOfUnits) + ", basketConstituentUnitOfMeasure=" + String.valueOf(this.basketConstituentUnitOfMeasure) + ", productDescription=" + this.productDescription + ", beneficiary=" + this.beneficiary + ", remarks=" + this.remarks + ", remarks1=" + this.remarks1 + ", remarks2=" + this.remarks2 + ", remarks3=" + this.remarks3 + ", remarks4=" + this.remarks4 + ", remarks5=" + this.remarks5 + ", remarks6=" + this.remarks6 + ", remarks7=" + this.remarks7 + ", remarks8=" + this.remarks8 + ", remarks9=" + this.remarks9 + ", remarks10=" + this.remarks10 + ", remarks11=" + this.remarks11 + ", remarks12=" + this.remarks12 + ", remarks13=" + this.remarks13 + ", uniqueProductIdentifierProprietary=" + this.uniqueProductIdentifierProprietary + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", centralCounterpartyIdentifierFormat=" + String.valueOf((Object)this.centralCounterpartyIdentifierFormat) + ", centralCounterpartySchemeName=" + String.valueOf((Object)this.centralCounterpartySchemeName) + ", brokerIdentifierFormat=" + String.valueOf((Object)this.brokerIdentifierFormat) + ", brokerSchemeName=" + String.valueOf((Object)this.brokerSchemeName) + ", referenceEntityFormat=" + String.valueOf((Object)this.referenceEntityFormat) + ", clearingMemberIdentifierFormat=" + String.valueOf((Object)this.clearingMemberIdentifierFormat) + ", clearingMemberSchemeName=" + String.valueOf((Object)this.clearingMemberSchemeName) + ", priorUTIProprietarySchemeName=" + String.valueOf((Object)this.priorUTIProprietarySchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "} " + super.toString();
        }
    }

    public static interface HKMATransactionReportBuilder
    extends HKMATransactionReport,
    CommonTransactionReport.CommonTransactionReportBuilder {
        @Override
        public HKMATransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setCounterparty1(String var1);

        @Override
        public HKMATransactionReportBuilder setCounterparty2(String var1);

        @Override
        public HKMATransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public HKMATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public HKMATransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public HKMATransactionReportBuilder setClearingMember(String var1);

        @Override
        public HKMATransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public HKMATransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public HKMATransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public HKMATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public HKMATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public HKMATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public HKMATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public HKMATransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public HKMATransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public HKMATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public HKMATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public HKMATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public HKMATransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public HKMATransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public HKMATransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public HKMATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public HKMATransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setPriorUTI(String var1);

        @Override
        public HKMATransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public HKMATransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public HKMATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public HKMATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public HKMATransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public HKMATransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public HKMATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public HKMATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public HKMATransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public HKMATransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public HKMATransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public HKMATransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public HKMATransactionReportBuilder setLeg1(Leg var1);

        @Override
        public HKMATransactionReportBuilder setLeg2(Leg var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public HKMATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public HKMATransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public HKMATransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public HKMATransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public HKMATransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public HKMATransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public HKMATransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public HKMATransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public HKMATransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public HKMATransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public HKMATransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public HKMATransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public HKMATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public HKMATransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public HKMATransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public HKMATransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public HKMATransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public HKMATransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public HKMATransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public HKMATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public HKMATransactionReportBuilder setSeries(Integer var1);

        @Override
        public HKMATransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public HKMATransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public HKMATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public HKMATransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public HKMATransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setPriorUSI(String var1);

        @Override
        public HKMATransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMATransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public HKMATransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public HKMATransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public HKMATransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setBrokerID(String var1);

        @Override
        public HKMATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public HKMATransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public HKMATransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public HKMATransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public HKMATransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public HKMATransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public HKMATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public HKMATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public HKMATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public HKMATransactionReportBuilder setBaseProduct(String var1);

        @Override
        public HKMATransactionReportBuilder setSubProduct(String var1);

        @Override
        public HKMATransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public HKMATransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public HKMATransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public HKMATransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public HKMATransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public HKMATransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public HKMATransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public HKMATransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public HKMATransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public HKMATransactionReportBuilder setNonReportable(NonReportable var1);

        public HKMATransactionReportBuilder setTechnicalRecordIdOverriddenAsString(String var1);

        public HKMATransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public HKMATransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType var1);

        public HKMATransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass var1);

        public HKMATransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String var1);

        public HKMATransactionReportBuilder setEntityResponsibleForReportingOverriddenAsString(String var1);

        public HKMATransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum var1);

        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal var1);

        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal var1, int var2);

        public HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(List<BigDecimal> var1);

        public HKMATransactionReportBuilder setBasketConstituentNumberOfUnits(List<BigDecimal> var1);

        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String var1);

        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String var1, int var2);

        public HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(List<String> var1);

        public HKMATransactionReportBuilder setBasketConstituentUnitOfMeasure(List<String> var1);

        public HKMATransactionReportBuilder setProductDescription(String var1);

        public HKMATransactionReportBuilder setBeneficiary(String var1);

        public HKMATransactionReportBuilder setRemarks(String var1);

        public HKMATransactionReportBuilder setRemarks1(String var1);

        public HKMATransactionReportBuilder setRemarks2(String var1);

        public HKMATransactionReportBuilder setRemarks3(String var1);

        public HKMATransactionReportBuilder setRemarks4(String var1);

        public HKMATransactionReportBuilder setRemarks5(String var1);

        public HKMATransactionReportBuilder setRemarks6(String var1);

        public HKMATransactionReportBuilder setRemarks7(String var1);

        public HKMATransactionReportBuilder setRemarks8(String var1);

        public HKMATransactionReportBuilder setRemarks9(String var1);

        public HKMATransactionReportBuilder setRemarks10(String var1);

        public HKMATransactionReportBuilder setRemarks11(String var1);

        public HKMATransactionReportBuilder setRemarks12(String var1);

        public HKMATransactionReportBuilder setRemarks13(String var1);

        public HKMATransactionReportBuilder setUniqueProductIdentifierProprietary(String var1);

        public HKMATransactionReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMATransactionReportBuilder setCounterparty2SchemeName(HKTRPartyScheme var1);

        public HKMATransactionReportBuilder setCentralCounterpartyIdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMATransactionReportBuilder setCentralCounterpartySchemeName(HKTRPartyScheme var1);

        public HKMATransactionReportBuilder setBrokerIdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMATransactionReportBuilder setBrokerSchemeName(HKTRPartyScheme var1);

        public HKMATransactionReportBuilder setReferenceEntityFormat(ReferenceEntityFormatEnum var1);

        public HKMATransactionReportBuilder setClearingMemberIdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMATransactionReportBuilder setClearingMemberSchemeName(HKTRPartyScheme var1);

        public HKMATransactionReportBuilder setPriorUTIProprietarySchemeName(UTIProprietarySchemeNameEnum var1);

        public HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, (RosettaModelObjectBuilder)this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basketConstituentNumberOfUnits"), BigDecimal.class, this.getBasketConstituentNumberOfUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basketConstituentUnitOfMeasure"), String.class, this.getBasketConstituentUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productDescription"), String.class, (Object)this.getProductDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary"), String.class, (Object)this.getBeneficiary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks1"), String.class, (Object)this.getRemarks1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks2"), String.class, (Object)this.getRemarks2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks3"), String.class, (Object)this.getRemarks3(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks4"), String.class, (Object)this.getRemarks4(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks5"), String.class, (Object)this.getRemarks5(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks6"), String.class, (Object)this.getRemarks6(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks7"), String.class, (Object)this.getRemarks7(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks8"), String.class, (Object)this.getRemarks8(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks9"), String.class, (Object)this.getRemarks9(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks10"), String.class, (Object)this.getRemarks10(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks11"), String.class, (Object)this.getRemarks11(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks12"), String.class, (Object)this.getRemarks12(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks13"), String.class, (Object)this.getRemarks13(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifierProprietary"), String.class, (Object)this.getUniqueProductIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterpartyIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCentralCounterpartyIdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterpartySchemeName"), HKTRPartyScheme.class, (Object)this.getCentralCounterpartySchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getBrokerIdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerSchemeName"), HKTRPartyScheme.class, (Object)this.getBrokerSchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntityFormat"), ReferenceEntityFormatEnum.class, (Object)this.getReferenceEntityFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMemberIdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getClearingMemberIdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMemberSchemeName"), HKTRPartyScheme.class, (Object)this.getClearingMemberSchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getPriorUTIProprietarySchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public HKMATransactionReportBuilder prune();
    }

    public static class HKMATransactionReportImpl
    extends CommonTransactionReport.CommonTransactionReportImpl
    implements HKMATransactionReport {
        private final String technicalRecordId;
        private final ZonedDateTime eventTimestamp;
        private final CommonContractType contractType;
        private final CommonAssetClass assetClass;
        private final Boolean counterparty2IdentifierType;
        private final String variationMarginCollateralPortfolioCode;
        private final String entityResponsibleForReporting;
        private final NatureOfCounterpartyEnum natureOfCounterparty1;
        private final List<BigDecimal> basketConstituentNumberOfUnits;
        private final List<String> basketConstituentUnitOfMeasure;
        private final String productDescription;
        private final String beneficiary;
        private final String remarks;
        private final String remarks1;
        private final String remarks2;
        private final String remarks3;
        private final String remarks4;
        private final String remarks5;
        private final String remarks6;
        private final String remarks7;
        private final String remarks8;
        private final String remarks9;
        private final String remarks10;
        private final String remarks11;
        private final String remarks12;
        private final String remarks13;
        private final String uniqueProductIdentifierProprietary;
        private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        private final HKTRPartyScheme counterparty2SchemeName;
        private final PartyIdentifierFormat2Enum centralCounterpartyIdentifierFormat;
        private final HKTRPartyScheme centralCounterpartySchemeName;
        private final PartyIdentifierFormat2Enum brokerIdentifierFormat;
        private final HKTRPartyScheme brokerSchemeName;
        private final ReferenceEntityFormatEnum referenceEntityFormat;
        private final PartyIdentifierFormat2Enum clearingMemberIdentifierFormat;
        private final HKTRPartyScheme clearingMemberSchemeName;
        private final UTIProprietarySchemeNameEnum priorUTIProprietarySchemeName;
        private final UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        protected HKMATransactionReportImpl(HKMATransactionReportBuilder builder) {
            super(builder);
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.eventTimestamp = builder.getEventTimestamp();
            this.contractType = builder.getContractType();
            this.assetClass = builder.getAssetClass();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
            this.basketConstituentNumberOfUnits = Optional.ofNullable(builder.getBasketConstituentNumberOfUnits()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.basketConstituentUnitOfMeasure = Optional.ofNullable(builder.getBasketConstituentUnitOfMeasure()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.productDescription = builder.getProductDescription();
            this.beneficiary = builder.getBeneficiary();
            this.remarks = builder.getRemarks();
            this.remarks1 = builder.getRemarks1();
            this.remarks2 = builder.getRemarks2();
            this.remarks3 = builder.getRemarks3();
            this.remarks4 = builder.getRemarks4();
            this.remarks5 = builder.getRemarks5();
            this.remarks6 = builder.getRemarks6();
            this.remarks7 = builder.getRemarks7();
            this.remarks8 = builder.getRemarks8();
            this.remarks9 = builder.getRemarks9();
            this.remarks10 = builder.getRemarks10();
            this.remarks11 = builder.getRemarks11();
            this.remarks12 = builder.getRemarks12();
            this.remarks13 = builder.getRemarks13();
            this.uniqueProductIdentifierProprietary = builder.getUniqueProductIdentifierProprietary();
            this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
            this.counterparty2SchemeName = builder.getCounterparty2SchemeName();
            this.centralCounterpartyIdentifierFormat = builder.getCentralCounterpartyIdentifierFormat();
            this.centralCounterpartySchemeName = builder.getCentralCounterpartySchemeName();
            this.brokerIdentifierFormat = builder.getBrokerIdentifierFormat();
            this.brokerSchemeName = builder.getBrokerSchemeName();
            this.referenceEntityFormat = builder.getReferenceEntityFormat();
            this.clearingMemberIdentifierFormat = builder.getClearingMemberIdentifierFormat();
            this.clearingMemberSchemeName = builder.getClearingMemberSchemeName();
            this.priorUTIProprietarySchemeName = builder.getPriorUTIProprietarySchemeName();
            this.uniqueTransactionIdentifierProprietarySchemeName = builder.getUniqueTransactionIdentifierProprietarySchemeName();
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
            return this.natureOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="basketConstituentNumberOfUnits")
        @RuneAttribute(value="basketConstituentNumberOfUnits")
        public List<BigDecimal> getBasketConstituentNumberOfUnits() {
            return this.basketConstituentNumberOfUnits;
        }

        @Override
        @RosettaAttribute(value="basketConstituentUnitOfMeasure")
        @RuneAttribute(value="basketConstituentUnitOfMeasure")
        public List<String> getBasketConstituentUnitOfMeasure() {
            return this.basketConstituentUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="productDescription")
        @RuneAttribute(value="productDescription")
        public String getProductDescription() {
            return this.productDescription;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public String getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="remarks1")
        @RuneAttribute(value="remarks1")
        public String getRemarks1() {
            return this.remarks1;
        }

        @Override
        @RosettaAttribute(value="remarks2")
        @RuneAttribute(value="remarks2")
        public String getRemarks2() {
            return this.remarks2;
        }

        @Override
        @RosettaAttribute(value="remarks3")
        @RuneAttribute(value="remarks3")
        public String getRemarks3() {
            return this.remarks3;
        }

        @Override
        @RosettaAttribute(value="remarks4")
        @RuneAttribute(value="remarks4")
        public String getRemarks4() {
            return this.remarks4;
        }

        @Override
        @RosettaAttribute(value="remarks5")
        @RuneAttribute(value="remarks5")
        public String getRemarks5() {
            return this.remarks5;
        }

        @Override
        @RosettaAttribute(value="remarks6")
        @RuneAttribute(value="remarks6")
        public String getRemarks6() {
            return this.remarks6;
        }

        @Override
        @RosettaAttribute(value="remarks7")
        @RuneAttribute(value="remarks7")
        public String getRemarks7() {
            return this.remarks7;
        }

        @Override
        @RosettaAttribute(value="remarks8")
        @RuneAttribute(value="remarks8")
        public String getRemarks8() {
            return this.remarks8;
        }

        @Override
        @RosettaAttribute(value="remarks9")
        @RuneAttribute(value="remarks9")
        public String getRemarks9() {
            return this.remarks9;
        }

        @Override
        @RosettaAttribute(value="remarks10")
        @RuneAttribute(value="remarks10")
        public String getRemarks10() {
            return this.remarks10;
        }

        @Override
        @RosettaAttribute(value="remarks11")
        @RuneAttribute(value="remarks11")
        public String getRemarks11() {
            return this.remarks11;
        }

        @Override
        @RosettaAttribute(value="remarks12")
        @RuneAttribute(value="remarks12")
        public String getRemarks12() {
            return this.remarks12;
        }

        @Override
        @RosettaAttribute(value="remarks13")
        @RuneAttribute(value="remarks13")
        public String getRemarks13() {
            return this.remarks13;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifierProprietary")
        @RuneAttribute(value="uniqueProductIdentifierProprietary")
        public String getUniqueProductIdentifierProprietary() {
            return this.uniqueProductIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartyIdentifierFormat")
        @RuneAttribute(value="centralCounterpartyIdentifierFormat")
        public PartyIdentifierFormat2Enum getCentralCounterpartyIdentifierFormat() {
            return this.centralCounterpartyIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="centralCounterpartySchemeName")
        @RuneAttribute(value="centralCounterpartySchemeName")
        public HKTRPartyScheme getCentralCounterpartySchemeName() {
            return this.centralCounterpartySchemeName;
        }

        @Override
        @RosettaAttribute(value="brokerIdentifierFormat")
        @RuneAttribute(value="brokerIdentifierFormat")
        public PartyIdentifierFormat2Enum getBrokerIdentifierFormat() {
            return this.brokerIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="brokerSchemeName")
        @RuneAttribute(value="brokerSchemeName")
        public HKTRPartyScheme getBrokerSchemeName() {
            return this.brokerSchemeName;
        }

        @Override
        @RosettaAttribute(value="referenceEntityFormat")
        @RuneAttribute(value="referenceEntityFormat")
        public ReferenceEntityFormatEnum getReferenceEntityFormat() {
            return this.referenceEntityFormat;
        }

        @Override
        @RosettaAttribute(value="clearingMemberIdentifierFormat")
        @RuneAttribute(value="clearingMemberIdentifierFormat")
        public PartyIdentifierFormat2Enum getClearingMemberIdentifierFormat() {
            return this.clearingMemberIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="clearingMemberSchemeName")
        @RuneAttribute(value="clearingMemberSchemeName")
        public HKTRPartyScheme getClearingMemberSchemeName() {
            return this.clearingMemberSchemeName;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietarySchemeName")
        @RuneAttribute(value="priorUTIProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getPriorUTIProprietarySchemeName() {
            return this.priorUTIProprietarySchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        public HKMATransactionReport build() {
            return this;
        }

        @Override
        public HKMATransactionReportBuilder toBuilder() {
            HKMATransactionReportBuilder builder = HKMATransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(HKMATransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordIdOverriddenAsString);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractTypeOverriddenAsCommonContractType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClassOverriddenAsCommonAssetClass);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCodeOverriddenAsString);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReportingOverriddenAsString);
            Optional.ofNullable(this.getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum);
            Optional.ofNullable(this.getBasketConstituentNumberOfUnits()).ifPresent(builder::setBasketConstituentNumberOfUnits);
            Optional.ofNullable(this.getBasketConstituentUnitOfMeasure()).ifPresent(builder::setBasketConstituentUnitOfMeasure);
            Optional.ofNullable(this.getProductDescription()).ifPresent(builder::setProductDescription);
            Optional.ofNullable(this.getBeneficiary()).ifPresent(builder::setBeneficiary);
            Optional.ofNullable(this.getRemarks()).ifPresent(builder::setRemarks);
            Optional.ofNullable(this.getRemarks1()).ifPresent(builder::setRemarks1);
            Optional.ofNullable(this.getRemarks2()).ifPresent(builder::setRemarks2);
            Optional.ofNullable(this.getRemarks3()).ifPresent(builder::setRemarks3);
            Optional.ofNullable(this.getRemarks4()).ifPresent(builder::setRemarks4);
            Optional.ofNullable(this.getRemarks5()).ifPresent(builder::setRemarks5);
            Optional.ofNullable(this.getRemarks6()).ifPresent(builder::setRemarks6);
            Optional.ofNullable(this.getRemarks7()).ifPresent(builder::setRemarks7);
            Optional.ofNullable(this.getRemarks8()).ifPresent(builder::setRemarks8);
            Optional.ofNullable(this.getRemarks9()).ifPresent(builder::setRemarks9);
            Optional.ofNullable(this.getRemarks10()).ifPresent(builder::setRemarks10);
            Optional.ofNullable(this.getRemarks11()).ifPresent(builder::setRemarks11);
            Optional.ofNullable(this.getRemarks12()).ifPresent(builder::setRemarks12);
            Optional.ofNullable(this.getRemarks13()).ifPresent(builder::setRemarks13);
            Optional.ofNullable(this.getUniqueProductIdentifierProprietary()).ifPresent(builder::setUniqueProductIdentifierProprietary);
            Optional.ofNullable(this.getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
            Optional.ofNullable(this.getCounterparty2SchemeName()).ifPresent(builder::setCounterparty2SchemeName);
            Optional.ofNullable(this.getCentralCounterpartyIdentifierFormat()).ifPresent(builder::setCentralCounterpartyIdentifierFormat);
            Optional.ofNullable(this.getCentralCounterpartySchemeName()).ifPresent(builder::setCentralCounterpartySchemeName);
            Optional.ofNullable(this.getBrokerIdentifierFormat()).ifPresent(builder::setBrokerIdentifierFormat);
            Optional.ofNullable(this.getBrokerSchemeName()).ifPresent(builder::setBrokerSchemeName);
            Optional.ofNullable(this.getReferenceEntityFormat()).ifPresent(builder::setReferenceEntityFormat);
            Optional.ofNullable(this.getClearingMemberIdentifierFormat()).ifPresent(builder::setClearingMemberIdentifierFormat);
            Optional.ofNullable(this.getClearingMemberSchemeName()).ifPresent(builder::setClearingMemberSchemeName);
            Optional.ofNullable(this.getPriorUTIProprietarySchemeName()).ifPresent(builder::setPriorUTIProprietarySchemeName);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietarySchemeName()).ifPresent(builder::setUniqueTransactionIdentifierProprietarySchemeName);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMATransactionReport _that = (HKMATransactionReport)this.getType().cast(o);
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals((Object)this.natureOfCounterparty1, (Object)_that.getNatureOfCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituentNumberOfUnits, _that.getBasketConstituentNumberOfUnits())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituentUnitOfMeasure, _that.getBasketConstituentUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.productDescription, _that.getProductDescription())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary, _that.getBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals(this.remarks1, _that.getRemarks1())) {
                return false;
            }
            if (!Objects.equals(this.remarks2, _that.getRemarks2())) {
                return false;
            }
            if (!Objects.equals(this.remarks3, _that.getRemarks3())) {
                return false;
            }
            if (!Objects.equals(this.remarks4, _that.getRemarks4())) {
                return false;
            }
            if (!Objects.equals(this.remarks5, _that.getRemarks5())) {
                return false;
            }
            if (!Objects.equals(this.remarks6, _that.getRemarks6())) {
                return false;
            }
            if (!Objects.equals(this.remarks7, _that.getRemarks7())) {
                return false;
            }
            if (!Objects.equals(this.remarks8, _that.getRemarks8())) {
                return false;
            }
            if (!Objects.equals(this.remarks9, _that.getRemarks9())) {
                return false;
            }
            if (!Objects.equals(this.remarks10, _that.getRemarks10())) {
                return false;
            }
            if (!Objects.equals(this.remarks11, _that.getRemarks11())) {
                return false;
            }
            if (!Objects.equals(this.remarks12, _that.getRemarks12())) {
                return false;
            }
            if (!Objects.equals(this.remarks13, _that.getRemarks13())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifierProprietary, _that.getUniqueProductIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.centralCounterpartyIdentifierFormat, (Object)_that.getCentralCounterpartyIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.centralCounterpartySchemeName, (Object)_that.getCentralCounterpartySchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.brokerIdentifierFormat, (Object)_that.getBrokerIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.brokerSchemeName, (Object)_that.getBrokerSchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceEntityFormat, (Object)_that.getReferenceEntityFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingMemberIdentifierFormat, (Object)_that.getClearingMemberIdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingMemberSchemeName, (Object)_that.getClearingMemberSchemeName())) {
                return false;
            }
            if (!Objects.equals((Object)this.priorUTIProprietarySchemeName, (Object)_that.getPriorUTIProprietarySchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.natureOfCounterparty1 != null ? ((Object)((Object)this.natureOfCounterparty1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.basketConstituentNumberOfUnits != null ? this.basketConstituentNumberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituentUnitOfMeasure != null ? this.basketConstituentUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.productDescription != null ? this.productDescription.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.remarks1 != null ? this.remarks1.hashCode() : 0);
            _result = 31 * _result + (this.remarks2 != null ? this.remarks2.hashCode() : 0);
            _result = 31 * _result + (this.remarks3 != null ? this.remarks3.hashCode() : 0);
            _result = 31 * _result + (this.remarks4 != null ? this.remarks4.hashCode() : 0);
            _result = 31 * _result + (this.remarks5 != null ? this.remarks5.hashCode() : 0);
            _result = 31 * _result + (this.remarks6 != null ? this.remarks6.hashCode() : 0);
            _result = 31 * _result + (this.remarks7 != null ? this.remarks7.hashCode() : 0);
            _result = 31 * _result + (this.remarks8 != null ? this.remarks8.hashCode() : 0);
            _result = 31 * _result + (this.remarks9 != null ? this.remarks9.hashCode() : 0);
            _result = 31 * _result + (this.remarks10 != null ? this.remarks10.hashCode() : 0);
            _result = 31 * _result + (this.remarks11 != null ? this.remarks11.hashCode() : 0);
            _result = 31 * _result + (this.remarks12 != null ? this.remarks12.hashCode() : 0);
            _result = 31 * _result + (this.remarks13 != null ? this.remarks13.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifierProprietary != null ? this.uniqueProductIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterpartyIdentifierFormat != null ? ((Object)((Object)this.centralCounterpartyIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterpartySchemeName != null ? ((Object)((Object)this.centralCounterpartySchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.brokerIdentifierFormat != null ? ((Object)((Object)this.brokerIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.brokerSchemeName != null ? ((Object)((Object)this.brokerSchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceEntityFormat != null ? ((Object)((Object)this.referenceEntityFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingMemberIdentifierFormat != null ? ((Object)((Object)this.clearingMemberIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingMemberSchemeName != null ? ((Object)((Object)this.clearingMemberSchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTIProprietarySchemeName != null ? ((Object)((Object)this.priorUTIProprietarySchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMATransactionReport {technicalRecordId=" + this.technicalRecordId + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", natureOfCounterparty1=" + String.valueOf((Object)this.natureOfCounterparty1) + ", basketConstituentNumberOfUnits=" + String.valueOf(this.basketConstituentNumberOfUnits) + ", basketConstituentUnitOfMeasure=" + String.valueOf(this.basketConstituentUnitOfMeasure) + ", productDescription=" + this.productDescription + ", beneficiary=" + this.beneficiary + ", remarks=" + this.remarks + ", remarks1=" + this.remarks1 + ", remarks2=" + this.remarks2 + ", remarks3=" + this.remarks3 + ", remarks4=" + this.remarks4 + ", remarks5=" + this.remarks5 + ", remarks6=" + this.remarks6 + ", remarks7=" + this.remarks7 + ", remarks8=" + this.remarks8 + ", remarks9=" + this.remarks9 + ", remarks10=" + this.remarks10 + ", remarks11=" + this.remarks11 + ", remarks12=" + this.remarks12 + ", remarks13=" + this.remarks13 + ", uniqueProductIdentifierProprietary=" + this.uniqueProductIdentifierProprietary + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", centralCounterpartyIdentifierFormat=" + String.valueOf((Object)this.centralCounterpartyIdentifierFormat) + ", centralCounterpartySchemeName=" + String.valueOf((Object)this.centralCounterpartySchemeName) + ", brokerIdentifierFormat=" + String.valueOf((Object)this.brokerIdentifierFormat) + ", brokerSchemeName=" + String.valueOf((Object)this.brokerSchemeName) + ", referenceEntityFormat=" + String.valueOf((Object)this.referenceEntityFormat) + ", clearingMemberIdentifierFormat=" + String.valueOf((Object)this.clearingMemberIdentifierFormat) + ", clearingMemberSchemeName=" + String.valueOf((Object)this.clearingMemberSchemeName) + ", priorUTIProprietarySchemeName=" + String.valueOf((Object)this.priorUTIProprietarySchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "} " + super.toString();
        }
    }
}

