/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import cdm.event.common.Trade;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.basket.functions.GetBasketConstituents;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.regulation.hkma.rewrite.trade.reports.BasketConstituentIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.BasketConstituentIdentifierSourceRule;
import drr.regulation.hkma.rewrite.trade.reports.BasketConstituentNumberOfUnitsRule;
import drr.regulation.hkma.rewrite.trade.reports.BasketConstituentUnitOfMeasureRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=BasketConstituentsRuleDefault.class)
public abstract class BasketConstituentsRule
implements ReportFunction<TransactionReportInstruction, List<? extends BasketConstituentsReport>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BasketConstituentIdentifierRule basketConstituentIdentifierRule;
    @Inject
    protected BasketConstituentIdentifierSourceRule basketConstituentIdentifierSourceRule;
    @Inject
    protected BasketConstituentNumberOfUnitsRule basketConstituentNumberOfUnitsRule;
    @Inject
    protected BasketConstituentUnitOfMeasureRule basketConstituentUnitOfMeasureRule;
    @Inject
    protected GetBasketConstituents getBasketConstituents;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends BasketConstituentsReport> evaluate(TransactionReportInstruction input) {
        List output;
        List<BasketConstituentsReport.BasketConstituentsReportBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(BasketConstituentsReport::build).collect(Collectors.toList());
            this.objectValidator.validate(BasketConstituentsReport.class, output);
        }
        return output;
    }

    protected abstract List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class BasketConstituentsRuleDefault
    extends BasketConstituentsRule {
        @Override
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder> output = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> assignOutput(List<BasketConstituentsReport.BasketConstituentsReportBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForHKMA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get())));
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> MapperC.of(this.getBasketConstituents.evaluate((Trade)item.get())));
            output = this.toBuilder(thenArg2.mapItem(item -> MapperS.of((Object)BasketConstituentsReport.builder().setIdentifier(this.basketConstituentIdentifierRule.evaluate((BasketConstituent)item.get())).setSource(this.basketConstituentIdentifierSourceRule.evaluate((BasketConstituent)item.get())).setNumberOfUnits(this.basketConstituentNumberOfUnitsRule.evaluate((BasketConstituent)item.get())).setUnitOfMeasure(this.basketConstituentUnitOfMeasureRule.evaluate((BasketConstituent)item.get())).build())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

