/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.datetime.functions;

import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.time.ZonedDateTime;

@ImplementedBy(value=ValuationTimestampFromValuationDefault.class)
public abstract class ValuationTimestampFromValuation
implements RosettaFunction {
    public ZonedDateTime evaluate(Valuation valuation) {
        ZonedDateTime valuationTimestamp = this.doEvaluate(valuation);
        return valuationTimestamp;
    }

    protected abstract ZonedDateTime doEvaluate(Valuation var1);

    public static class ValuationTimestampFromValuationDefault
    extends ValuationTimestampFromValuation {
        @Override
        protected ZonedDateTime doEvaluate(Valuation valuation) {
            ZonedDateTime valuationTimestamp = null;
            return this.assignOutput(valuationTimestamp, valuation);
        }

        protected ZonedDateTime assignOutput(ZonedDateTime valuationTimestamp, Valuation valuation) {
            valuationTimestamp = (ZonedDateTime)MapperS.of((Object)valuation).map("getTimestamp", _valuation -> _valuation.getTimestamp()).get();
            return valuationTimestamp;
        }
    }
}

