/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.datetime.reports;

import cdm.base.datetime.AdjustableDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsProductOTC;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.PositionForEvent;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradeForEvent;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import drr.regulation.common.TransactionReportInstruction;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=EffectiveDateRuleDefault.class)
public abstract class EffectiveDateRule
implements ReportFunction<TransactionReportInstruction, Date> {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsProductOTC isProductOTC;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Date evaluate(TransactionReportInstruction input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    public static class EffectiveDateRuleDefault
    extends EffectiveDateRule {
        @Override
        protected Date doEvaluate(TransactionReportInstruction input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, TransactionReportInstruction input) {
            output = (Date)MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))).map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductOTC.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg = MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(_item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)_item.get())));
                    return thenArg.min();
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get())).map("getTradeDate", trade -> trade.getTradeDate()).map("Type coercion", fieldWithMetaDate -> fieldWithMetaDate == null ? null : fieldWithMetaDate.getValue());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.positionForEvent.evaluate((ReportableEventBase)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.positionForEvent.evaluate((ReportableEventBase)item.get())).map("getOpenDateTime", counterpartyPosition -> counterpartyPosition.getOpenDateTime()).map("Date", dt -> Date.of((LocalDate)dt.toLocalDate()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

