/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityOption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.base.trade.price.functions.GetReportableSchedulePeriod;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableStrikePricePeriodDefault.class)
public abstract class GetReportableStrikePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetReportableSchedulePeriod getReportableSchedulePeriod;
    @Inject
    protected IsCommodityOption isCommodityOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected StrikePrice strikePrice;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends PricePeriod> evaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
        List reportablePeriod;
        List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent, notation);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent var1, PriceNotationEnum var2);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent var1, PriceNotationEnum var2);

    protected abstract MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent var1, PriceNotationEnum var2);

    public static class GetReportableStrikePricePeriodDefault
    extends GetReportableStrikePricePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent, PriceNotationEnum notation) {
            reportablePeriod.addAll(this.toBuilder(this.getReportableSchedulePeriod.evaluate((PriceSchedule)this.strikePriceSchedule(reportableEvent, notation).get(), (CalculationSchedule)this.customizedSchedule(reportableEvent, notation).get(), notation)));
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCommodityOption.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent))))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((CalculationSchedule)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent)))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSchedule", optionPayout -> optionPayout.getSchedule()).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            return MapperS.of((Object)this.strikePrice.evaluate(reportableEvent));
        }
    }
}

