/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquityForward;
import cdm.product.qualification.functions.Qualify_Commodity_OptionOther;
import cdm.product.qualification.functions.Qualify_Credit_OptionOther;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.qualification.product.functions.IsCommoditySwapFixedFloat;
import drr.base.qualification.product.functions.IsEquitySwap;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.qualification.product.functions.IsTotalReturnSwapDebtUnderlier;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradableProductForEvent;
import drr.base.trade.quantity.functions.FixedPriceLeg1;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsEquityOther;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.standards.iosco.cde.version1.price.functions.PriceOfZeroCouponSwaps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceDefault.class)
public abstract class Price
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected IsCommodityForward isCommodityForward;
    @Inject
    protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
    @Inject
    protected IsEquityOther isEquityOther;
    @Inject
    protected IsEquitySwap isEquitySwap;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected IsProductETD isProductETD;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_BaseProduct_EquityForward qualify_BaseProduct_EquityForward;
    @Inject
    protected Qualify_Commodity_OptionOther qualify_Commodity_OptionOther;
    @Inject
    protected Qualify_Credit_OptionOther qualify_Credit_OptionOther;
    @Inject
    protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public PriceSchedule evaluate(ReportableEvent reportableEvent) {
        PriceSchedule price;
        PriceSchedule.PriceScheduleBuilder priceBuilder = this.doEvaluate(reportableEvent);
        if (priceBuilder == null) {
            price = null;
        } else {
            price = priceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)price);
        }
        return price;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends TradableProduct> tradableProduct(ReportableEvent var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent var1);

    public static class PriceDefault
    extends Price {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent reportableEvent) {
            PriceSchedule.PriceScheduleBuilder price = PriceSchedule.builder();
            return this.assignOutput(price, reportableEvent);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder price, ReportableEvent reportableEvent) {
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            MapperC thenArg = ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquitySwap.evaluate((TradableProduct)this.tradableProduct(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOther.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_OptionOther.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Credit_OptionOther.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.exists((Mapper)MapperS.of((Object)((PerformancePayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((PerformancePayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial())}) : this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue())) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_BaseProduct_EquityForward.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).or(ExpressionOperators.exists((Mapper)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((ProductTaxonomy)MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getBasket", product -> product.getBasket()).mapC("getProductTaxonomy", basket -> basket.getProductTaxonomy()).get())).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum == null ? null : fieldWithMetaAssetClassEnum.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti().isEmpty() ? MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()) : this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue())) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isTotalReturnSwapDebtUnderlier.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_InterestRate_Forward_Debt.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()) : (ExpressionOperators.onlyExists((Mapper)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout")).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()) : ((boolean0 = this.isCommoditySwapFixedFloat.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())) != null && boolean0.booleanValue() ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue())}) : ((boolean1 = this.isCommodityForward.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())) != null && boolean1.booleanValue() ? (ExpressionOperators.exists((Mapper)MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue())}) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()) : MapperC.ofNull())) : ((boolean2 = this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate(reportableEvent))) != null && boolean2 != false ? MapperC.of(Collections.singletonList(this.priceOfZeroCouponSwaps.evaluate(reportableEvent))) : MapperC.ofNull()))))));
            price = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PriceSchedule)thenArg.get())).get());
            return Optional.ofNullable(price).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends TradableProduct> tradableProduct(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.tradableProductForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()));
        }
    }
}

