/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.functions;

import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.TradableProductForEvent;
import drr.regulation.common.ReportableEvent;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceOfZeroCouponSwapsDefault.class)
public abstract class PriceOfZeroCouponSwaps
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public PriceSchedule evaluate(ReportableEvent reportableEvent) {
        PriceSchedule knownAmountPrice;
        PriceSchedule.PriceScheduleBuilder knownAmountPriceBuilder = this.doEvaluate(reportableEvent);
        if (knownAmountPriceBuilder == null) {
            knownAmountPrice = null;
        } else {
            knownAmountPrice = knownAmountPriceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)knownAmountPrice);
        }
        return knownAmountPrice;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent var1);

    public static class PriceOfZeroCouponSwapsDefault
    extends PriceOfZeroCouponSwaps {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent reportableEvent) {
            PriceSchedule.PriceScheduleBuilder knownAmountPrice = PriceSchedule.builder();
            return this.assignOutput(knownAmountPrice, reportableEvent);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder knownAmountPrice, ReportableEvent reportableEvent) {
            MapperC thenArg0 = MapperS.of((Object)this.tradableProductForEvent.evaluate(reportableEvent)).mapSingleToList(item -> item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()));
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
            MapperListOfLists thenArg2 = thenArg1.mapItemToList(item -> item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
            MapperC thenArg3 = thenArg2.flattenList();
            MapperS thenArg4 = MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg3.get()));
            knownAmountPrice = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)thenArg4.mapSingleToItem(item -> MapperS.of((Object)PriceSchedule.builder().setPriceType(PriceTypeEnum.CASH_PRICE).setUnit((UnitType)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).get()).setValue((BigDecimal)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get()).build())).get());
            return Optional.ofNullable(knownAmountPrice).map(o -> o.prune()).orElse(null);
        }
    }
}

