/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCap;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.qualification.product.functions.IsEquitySwap;
import drr.base.qualification.product.functions.IsFloor;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.qualification.product.functions.IsOption;
import drr.base.qualification.product.functions.IsVarianceSwap;
import drr.base.qualification.product.functions.IsVolatilitySwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradableProductForEvent;
import drr.base.trade.quantity.functions.FixedPriceLeg1;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceDefault.class)
public abstract class StrikePrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsEquitySwap isEquitySwap;
    @Inject
    protected IsFloor isFloor;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected IsOption isOption;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public PriceSchedule evaluate(ReportableEvent reportableEvent) {
        PriceSchedule prices;
        PriceSchedule.PriceScheduleBuilder pricesBuilder = this.doEvaluate(reportableEvent);
        if (pricesBuilder == null) {
            prices = null;
        } else {
            prices = pricesBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)prices);
        }
        return prices;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends TradableProduct> tradableProduct(ReportableEvent var1);

    protected abstract MapperS<? extends Product> product(ReportableEvent var1);

    public static class StrikePriceDefault
    extends StrikePrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEvent reportableEvent) {
            PriceSchedule.PriceScheduleBuilder prices = PriceSchedule.builder();
            return this.assignOutput(prices, reportableEvent);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder prices, ReportableEvent reportableEvent) {
            Boolean boolean4;
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            MapperC thenArg = ComparisonResult.of((Mapper)MapperS.of((Object)this.isIRSwaption.evaluate((Product)this.product(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()).map("getRateSchedule", fixedRateSpecification -> fixedRateSpecification.getRateSchedule()).map("getPrice", rateSchedule -> rateSchedule.getPrice()).map("Type coercion", _referenceWithMetaPriceSchedule -> _referenceWithMetaPriceSchedule.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get()))), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get()))).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue())}) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isOption.evaluate((Product)this.product(reportableEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isOption.evaluate((Product)this.product(reportableEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikeReference", optionStrike -> optionStrike.getStrikeReference()))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikeReference", optionStrike -> optionStrike.getStrikeReference()).map("Type coercion", referenceWithMetaFixedRateSpecification -> referenceWithMetaFixedRateSpecification.getValue()).map("getRateSchedule", fixedRateSpecification -> fixedRateSpecification.getRateSchedule()).map("getPrice", rateSchedule -> rateSchedule.getPrice()).map("Type coercion", _referenceWithMetaPriceSchedule -> _referenceWithMetaPriceSchedule.getValue()) : ((boolean0 = this.isCap.evaluate((Product)this.product(reportableEvent).get())) != null && boolean0 != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getCapRateSchedule", floatingRateSpecification -> floatingRateSpecification.getCapRateSchedule()).map("getPrice", strikeSchedule -> strikeSchedule.getPrice()).map("Type coercion", _referenceWithMetaPriceSchedule -> _referenceWithMetaPriceSchedule.getValue()) : ((boolean1 = this.isFloor.evaluate((Product)this.product(reportableEvent).get())) != null && boolean1 != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getFloorRateSchedule", floatingRateSpecification -> floatingRateSpecification.getFloorRateSchedule()).map("getPrice", strikeSchedule -> strikeSchedule.getPrice()).map("Type coercion", _referenceWithMetaPriceSchedule -> _referenceWithMetaPriceSchedule.getValue()) : ((boolean2 = this.isVarianceSwap.evaluate((Product)this.product(reportableEvent).get())) != null && boolean2 != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getVarianceStrikePrice", varianceReturnTerms -> varianceReturnTerms.getVarianceStrikePrice()) : ((boolean3 = this.isVolatilitySwap.evaluate((Product)this.product(reportableEvent).get())) != null && boolean3 != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getVolatilityReturnTerms", returnTerms -> returnTerms.getVolatilityReturnTerms()).map("getVolatilityStrikePrice", volatilityReturnTerms -> volatilityReturnTerms.getVolatilityStrikePrice()) : ((boolean4 = this.isEquitySwap.evaluate((TradableProduct)this.tradableProduct(reportableEvent).get())) != null && boolean4 != false ? this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.VARIANCE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.VOLATILITY), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()) : MapperC.ofNull()))))))));
            prices = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PriceSchedule)thenArg.get())).get());
            return Optional.ofNullable(prices).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends TradableProduct> tradableProduct(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.tradableProductForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }
    }
}

