/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Get_OptionPremiumOnEventDate;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumCurrencyRuleDefault.class)
public abstract class OptionPremiumCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected Get_OptionPremiumOnEventDate get_OptionPremiumOnEventDate;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class OptionPremiumCurrencyRuleDefault
    extends OptionPremiumCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)this.get_OptionPremiumOnEventDate.evaluate(input)).map("getQuantity", transfer -> transfer.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

