/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.price.reports.PackageTransactionPriceRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceValueRuleDefault.class)
public abstract class PackageTransactionPriceValueRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected PackageTransactionPriceRule packageTransactionPriceRule;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceValueRuleDefault
    extends PackageTransactionPriceValueRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)this.packageTransactionPriceRule.evaluate(input));
            output = (BigDecimal)thenArg.map("getValue", price -> price.getValue()).get();
            return output;
        }
    }
}

