/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationFromPrice;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.version1.price.functions.Price;
import javax.inject.Inject;

@ImplementedBy(value=PriceNotationRuleDefault.class)
public abstract class PriceNotationRule
implements ReportFunction<ReportableEvent, PriceNotationEnum> {
    @Inject
    protected NotationFromPrice notationFromPrice;
    @Inject
    protected Price price;

    public PriceNotationEnum evaluate(ReportableEvent input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(ReportableEvent var1);

    public static class PriceNotationRuleDefault
    extends PriceNotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(ReportableEvent input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, ReportableEvent input) {
            output = this.notationFromPrice.evaluate(this.price.evaluate(input));
            return output;
        }
    }
}

