/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceValueRuleDefault.class)
public abstract class StrikePriceValueRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected StrikePrice strikePrice;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceValueRuleDefault
    extends StrikePriceValueRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            output = (BigDecimal)MapperS.of((Object)this.strikePrice.evaluate(input)).map("getValue", priceSchedule -> priceSchedule.getValue()).get();
            return output;
        }
    }
}

