/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalFromLeg;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountDefault.class)
public abstract class NotionalAmount
implements RosettaFunction {
    @Inject
    protected NotionalFromLeg notionalFromLeg;

    public BigDecimal evaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
        BigDecimal notionalAmount = this.doEvaluate(payout, defaultValue);
        return notionalAmount;
    }

    protected abstract BigDecimal doEvaluate(PayoutLegWithAuxiliary var1, BigDecimal var2);

    public static class NotionalAmountDefault
    extends NotionalAmount {
        @Override
        protected BigDecimal doEvaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            BigDecimal notionalAmount = null;
            return this.assignOutput(notionalAmount, payout, defaultValue);
        }

        protected BigDecimal assignOutput(BigDecimal notionalAmount, PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            notionalAmount = (BigDecimal)MapperS.of((Object)payout).mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.notionalFromLeg.evaluate((PayoutLegWithAuxiliary)item.get())).map("getValue", measure -> measure.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)item.map("getZeroNotionalAmountDefaulting", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getZeroNotionalAmountDefaulting()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)defaultValue);
                }
                return MapperS.of((Object)this.notionalFromLeg.evaluate((PayoutLegWithAuxiliary)item.get())).map("getValue", measure -> measure.getValue());
            }).get();
            return notionalAmount;
        }
    }
}

