/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.functions;

import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.quantity.functions.GetProductForQuantity;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PayoutLeg2;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalAmountFormat;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountLeg2Default.class)
public abstract class NotionalAmountLeg2
implements RosettaFunction {
    @Inject
    protected GetProductForQuantity getProductForQuantity;
    @Inject
    protected NotionalAmountFormat notionalAmountFormat;
    @Inject
    protected PayoutLeg2 payoutLeg2;

    public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
        BigDecimal notionalAmount = this.doEvaluate(transactionReportInstruction, defaultValue);
        return notionalAmount;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1, BigDecimal var2);

    protected abstract MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstruction var1, BigDecimal var2);

    public static class NotionalAmountLeg2Default
    extends NotionalAmountLeg2 {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            BigDecimal notionalAmount = null;
            return this.assignOutput(notionalAmount, transactionReportInstruction, defaultValue);
        }

        protected BigDecimal assignOutput(BigDecimal notionalAmount, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            notionalAmount = this.notionalAmountFormat.evaluate((PayoutLegWithAuxiliary)this.payout(transactionReportInstruction, defaultValue).get(), defaultValue);
            return notionalAmount;
        }

        @Override
        protected MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            MapperS thenArg = MapperS.of((Object)this.getProductForQuantity.evaluate(transactionReportInstruction));
            return thenArg.mapSingleToItem(item -> MapperS.of((Object)this.payoutLeg2.evaluate((Product)item.map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), (TradeLot)item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ReportableInformation)MapperS.of((Object)transactionReportInstruction).map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).get())));
        }
    }
}

