/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.price.functions.Price;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceRuleDefault.class)
public abstract class PriceRule
implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Price price;

    public PriceSchedule evaluate(TransactionReportInstruction input) {
        PriceSchedule output;
        PriceSchedule.PriceScheduleBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PriceRuleDefault
    extends PriceRule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
            PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
            return this.assignOutput(output, input);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
            output = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)this.price.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

