/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.functions.CurrencyPairOrCurrencyFromPrice;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version2.price.functions.StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceCurrencyRuleDefault.class)
public abstract class StrikePriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CurrencyPairOrCurrencyFromPrice currencyPairOrCurrencyFromPrice;
    @Inject
    protected StrikePrice strikePrice;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceCurrencyRuleDefault
    extends StrikePriceCurrencyRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = this.currencyPairOrCurrencyFromPrice.evaluate(this.strikePrice.evaluate(input), true);
            return output;
        }
    }
}

