/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationFromPrice;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version2.price.functions.StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceNotationEnumRuleDefault.class)
public abstract class StrikePriceNotationEnumRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected NotationFromPrice notationFromPrice;
    @Inject
    protected StrikePrice strikePrice;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceNotationEnumRuleDefault
    extends StrikePriceNotationEnumRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            output = (PriceNotationEnum)((Object)MapperS.of((Object)this.strikePrice.evaluate(input)).mapSingleToItem(item -> MapperS.of((Object)((Object)this.notationFromPrice.evaluate((PriceSchedule)item.get())))).get());
            return output;
        }
    }
}

