/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.base.trade.quantity.NotionalPeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.SettlementTermsLeg1;
import drr.regulation.common.reports.PayoutFromProductLeg1Rule;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iosco.cde.version3.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version3.party.reports.Direction2Leg1Rule;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import drr.standards.iosco.cde.version3.price.reports.InterestRateFixedRateRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadValueRule;
import drr.standards.iosco.cde.version3.quantity.functions.NotionalAmountLeg1;
import drr.standards.iosco.cde.version3.quantity.functions.TotalNotionalQuantityLeg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.QuantityUnitOfMeasureLeg1Rule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg1Default.class)
public abstract class Leg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Direction2Leg1Rule direction2Leg1Rule;
    @Inject
    protected InterestRateFixedRateRule interestRateFixedRateRule;
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected NotionalAmountLeg1 notionalAmountLeg1;
    @Inject
    protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
    @Inject
    protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
    @Inject
    protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
    @Inject
    protected PayoutFromProductLeg1Rule payoutFromProductLeg1Rule;
    @Inject
    protected PeriodicPaymentRule periodicPaymentRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;
    @Inject
    protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
    @Inject
    protected SettlementCurrencyRule settlementCurrencyRule;
    @Inject
    protected SettlementTermsLeg1 settlementTermsLeg1;
    @Inject
    protected SpreadCurrencyRule spreadCurrencyRule;
    @Inject
    protected SpreadValueRule spreadValueRule;
    @Inject
    protected TotalNotionalQuantityLeg1 totalNotionalQuantityLeg1;

    public Leg evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
        Leg leg;
        Leg.LegBuilder legBuilder = this.doEvaluate(transaction, spreadNotation, defaultValue);
        if (legBuilder == null) {
            leg = null;
        } else {
            leg = legBuilder.build();
            this.objectValidator.validate(Leg.class, (RosettaModelObject)leg);
        }
        return leg;
    }

    protected abstract Leg.LegBuilder doEvaluate(TransactionReportInstruction var1, PriceNotationEnum var2, BigDecimal var3);

    public static class Leg1Default
    extends Leg1 {
        @Override
        protected Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            Leg.LegBuilder leg = Leg.builder();
            return this.assignOutput(leg, transaction, spreadNotation, defaultValue);
        }

        protected Leg.LegBuilder assignOutput(Leg.LegBuilder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            leg = (Leg.LegBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)transaction).mapSingleToItem(item -> {
                MapperS thenArg0 = item.mapSingleToItem(_item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)_item.get())));
                MapperS thenArg1 = thenArg0.mapSingleToItem(_item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)_item.get())));
                MapperS thenArg2 = item.mapSingleToItem(_item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)_item.get())));
                MapperS thenArg3 = thenArg2.mapSingleToItem(_item -> MapperS.of((Object)this.settlementTermsLeg1.evaluate((Product)_item.get())));
                return MapperS.of((Object)Leg.builder().setPeriodicPayment(this.periodicPaymentRule.evaluate(this.interestRateLeg1.evaluate(this.productOrUnderlierProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))))).setFixedRate((BigDecimal)MapperS.of((Object)this.interestRateFixedRateRule.evaluate(this.interestRateLeg1.evaluate((Product)thenArg1.get()))).get()).setNotionalAmount(this.notionalAmountLeg1.evaluate(transaction, defaultValue)).setNotionalCurrency(this.notionalCurrencyLeg1Rule.evaluate((TransactionReportInstruction)item.get())).setTotalNotionalQuantity(this.totalNotionalQuantityLeg1.evaluate(transaction, defaultValue)).setNotionalAmountSchedule(new ArrayList<NotionalPeriod>(this.notionalAmountScheduleLeg1Rule.evaluate((TransactionReportInstruction)item.get()))).setNotionalQuantitySchedule(new ArrayList<NotionalPeriod>(this.notionalQuantityScheduleLeg1Rule.evaluate((TransactionReportInstruction)item.get()))).setSettlementCurrency((ISOCurrencyCodeEnum)thenArg3.mapSingleToItem(_item -> MapperS.of((Object)this.settlementCurrencyRule.evaluate((SettlementTerms)_item.get()))).get()).setSpread((PriceFormat)item.mapSingleToItem(_item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.spreadValueRule.evaluate(this.payoutFromProductLeg1Rule.evaluate((TransactionReportInstruction)_item.get())), spreadNotation))).get()).setSpreadNotation(spreadNotation).setSpreadCurrency(this.spreadCurrencyRule.evaluate(this.payoutFromProductLeg1Rule.evaluate((TransactionReportInstruction)item.get()))).setQuantityUnitOfMeasure(this.quantityUnitOfMeasureLeg1Rule.evaluate((TransactionReportInstruction)item.get())).setDirection2(this.direction2Leg1Rule.evaluate((TransactionReportInstruction)item.get())).build());
            }).get());
            return Optional.ofNullable(leg).map(o -> o.prune()).orElse(null);
        }
    }
}

