/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.functions.Contract_Price;
import drr.base.trade.price.functions.CurrencyPairOrCurrencyFromPrice;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.price.functions.StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateBasisRuleDefault.class)
public abstract class ExchangeRateBasisRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected CurrencyPairOrCurrencyFromPrice currencyPairOrCurrencyFromPrice;
    @Inject
    protected StrikePrice strikePrice;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateBasisRuleDefault
    extends ExchangeRateBasisRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperC thenArg0 = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperS.of((Object)this.strikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator())).get());
            MapperS thenArg1 = thenArg0.last();
            output = (String)MapperS.of((Object)this.currencyPairOrCurrencyFromPrice.evaluate((PriceSchedule)thenArg1.get(), false)).get();
            return output;
        }
    }
}

