/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.functions.CurrentSchedulePeriod;
import drr.base.trade.price.functions.ExtractPriceValue;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.price.reports.PriceRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PriceValueRuleDefault.class)
public abstract class PriceValueRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected CurrentSchedulePeriod currentSchedulePeriod;
    @Inject
    protected ExtractPriceValue extractPriceValue;
    @Inject
    protected PriceRule priceRule;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class PriceValueRuleDefault
    extends PriceValueRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            output = this.extractPriceValue.evaluate(this.priceRule.evaluate(input), this.currentSchedulePeriod.evaluate(input));
            return output;
        }
    }
}

