/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.rosetta.model.lib.records.Date;
import drr.standards.iso.MicData;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.MicTypeEnum;
import drr.standards.iso.functions.API_GetMicData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.iso10383.Dataroot;
import org.iso10383.ISO10383MIC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API_GetMicDataImpl
extends API_GetMicData {
    private static final Logger LOGGER = LoggerFactory.getLogger(API_GetMicDataImpl.class);
    private static final String DATA_SOURCE_URL = "https://www.iso20022.org/sites/default/files/ISO10383_MIC/ISO10383_MIC.xml";
    private final HttpClient httpClient;
    private final JAXBContext jaxbContext;
    @VisibleForTesting
    protected final Cache<String, MicData.MicDataBuilder> micDataCache = CacheBuilder.newBuilder().maximumSize(3000L).build();

    public API_GetMicDataImpl() {
        this(HttpClient.newBuilder().executor(Executors.newFixedThreadPool(3)).build());
    }

    @VisibleForTesting
    public API_GetMicDataImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Dataroot.class});
        }
        catch (JAXBException e) {
            LOGGER.error("JAXBContext Exception ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected MicData.MicDataBuilder doEvaluate(String mic) {
        if (null == mic) {
            return null;
        }
        if (this.micDataCache.size() == 0L) {
            Map<String, MicData.MicDataBuilder> data = this.load().stream().collect(Collectors.toMap(m -> m.getMic(), m -> m));
            this.micDataCache.putAll(data);
        }
        MicData.MicDataBuilder micData = Optional.ofNullable(mic).map(arg_0 -> this.micDataCache.getIfPresent(arg_0)).orElse(null);
        LOGGER.info("Looked up mic {} and found data {}", (Object)mic, (Object)micData);
        return micData;
    }

    private List<MicData.MicDataBuilder> load() {
        LOGGER.info("Loading ISO10383_MIC data from www.iso20022.org");
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(DATA_SOURCE_URL)).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
            CompletionStage httpResponse = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
            LOGGER.debug("Waiting for response");
            String body = (String)((CompletableFuture)httpResponse).join();
            LOGGER.debug("Got response");
            Dataroot dataroot = this.parseResponse(body);
            List<MicData.MicDataBuilder> micData = dataroot.getISO10383MIC().stream().map(this::toMicData).collect(Collectors.toList());
            LOGGER.info("Loaded {} mic data item", (Object)micData.size());
            return micData;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred getting ISO10383_MIC data from www.iso20022.org", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected Dataroot parseResponse(String response) throws JAXBException {
        Unmarshaller jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.removeLineBreaks(response).getBytes(StandardCharsets.UTF_8));
        return (Dataroot)jaxbUnmarshaller.unmarshal((InputStream)inputStream);
    }

    private String removeLineBreaks(String response) {
        return response.replace("\n", "").replace("\t", "");
    }

    private MicData.MicDataBuilder toMicData(ISO10383MIC iso10383MIC) {
        MicData.MicDataBuilder micEnrichmentInformation = MicData.builder().setMic(API_GetMicDataImpl.trim(iso10383MIC.getMIC())).setOperatingMic(API_GetMicDataImpl.trim(iso10383MIC.getOPERATINGX0020MIC())).setNameInstitutionDescription(API_GetMicDataImpl.trim(iso10383MIC.getMARKETX0020NAMEINSTITUTIONX0020DESCRIPTION())).setLegalEntityName(API_GetMicDataImpl.trim(iso10383MIC.getLEGALX0020ENTITYX0020NAME())).setAcronym(API_GetMicDataImpl.trim(iso10383MIC.getACRONYM())).setCountryCode(API_GetMicDataImpl.trim(iso10383MIC.getISOX0020COUNTRYX0020CODEX0020X0028ISOX00203166X0029())).setCity(API_GetMicDataImpl.trim(iso10383MIC.getCITY())).setWebsite(API_GetMicDataImpl.trim(iso10383MIC.getWEBSITE())).setStatus(API_GetMicDataImpl.trim(iso10383MIC.getSTATUS())).setCreationDate(this.parseDate(iso10383MIC.getCREATIONX0020DATE())).setLastUpdateDate(this.parseDate(iso10383MIC.getLASTX0020UPDATEX0020DATE())).setLastValidationDate(this.parseDate(iso10383MIC.getLASTX0020VALIDATIONX0020DATE())).setExpiryDate(this.parseDate(iso10383MIC.getEXPIRYX0020DATE()));
        Optional.ofNullable(API_GetMicDataImpl.trim(iso10383MIC.getOPRTX002FSGMT())).map(this::toMicTypeEnum).ifPresent(micEnrichmentInformation::setMicType);
        Optional.ofNullable(API_GetMicDataImpl.trim(iso10383MIC.getMARKETX0020CATEGORYX0020CODE())).map(this::toMarketCategoryEnum).ifPresent(micEnrichmentInformation::setMarketCategory);
        return micEnrichmentInformation;
    }

    private Date parseDate(String date) {
        if ("".equals(date = API_GetMicDataImpl.trim(date)) || null == date) {
            return null;
        }
        return Date.of((LocalDate)LocalDate.parse(date, DateTimeFormatter.BASIC_ISO_DATE));
    }

    private static String trim(String s) {
        return Optional.ofNullable(s).map(String::trim).filter(str -> !str.isEmpty()).orElse(null);
    }

    private MicTypeEnum toMicTypeEnum(String micType) {
        try {
            return MicTypeEnum.valueOf(micType);
        }
        catch (Exception e) {
            LOGGER.warn("Unknown MIC type received {}", (Object)micType);
            return null;
        }
    }

    private MicMarketCategoryEnum toMarketCategoryEnum(String marketCategory) {
        try {
            return MicMarketCategoryEnum.valueOf(marketCategory);
        }
        catch (Exception e) {
            LOGGER.warn("Unknown MIC market category received {}", (Object)marketCategory);
            return null;
        }
    }
}

