/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.MicData;
import drr.standards.iso.functions.API_GetMicData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOrFetchMicDataDefault.class)
public abstract class GetOrFetchMicData
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected API_GetMicData aPI_GetMicData;

    public MicData evaluate(List<? extends MicData> preEnriched, String mic) {
        MicData micData;
        MicData.MicDataBuilder micDataBuilder = this.doEvaluate(preEnriched, mic);
        if (micDataBuilder == null) {
            micData = null;
        } else {
            micData = micDataBuilder.build();
            this.objectValidator.validate(MicData.class, (RosettaModelObject)micData);
        }
        return micData;
    }

    protected abstract MicData.MicDataBuilder doEvaluate(List<? extends MicData> var1, String var2);

    protected abstract MapperS<? extends MicData> preEnrichedMicData(List<? extends MicData> var1, String var2);

    protected abstract MapperS<Boolean> isEnabled(List<? extends MicData> var1, String var2);

    public static class GetOrFetchMicDataDefault
    extends GetOrFetchMicData {
        @Override
        protected MicData.MicDataBuilder doEvaluate(List<? extends MicData> preEnriched, String mic) {
            if (preEnriched == null) {
                preEnriched = Collections.emptyList();
            }
            MicData.MicDataBuilder micData = MicData.builder();
            return this.assignOutput(micData, preEnriched, mic);
        }

        protected MicData.MicDataBuilder assignOutput(MicData.MicDataBuilder micData, List<? extends MicData> preEnriched, String mic) {
            micData = ExpressionOperators.areEqual(this.isEnabled(preEnriched, mic), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? null : (ExpressionOperators.exists(this.preEnrichedMicData(preEnriched, mic)).getOrDefault(Boolean.valueOf(false)) != false ? (MicData.MicDataBuilder)this.toBuilder((RosettaModelObject)this.preEnrichedMicData(preEnriched, mic).get()) : (MicData.MicDataBuilder)this.toBuilder(this.aPI_GetMicData.evaluate(mic)));
            return Optional.ofNullable(micData).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends MicData> preEnrichedMicData(List<? extends MicData> preEnriched, String mic) {
            MapperC thenArg = MapperC.of(preEnriched).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getMic", micData -> micData.getMic()), (Mapper)MapperS.of((Object)mic), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((MicData)thenArg.get()));
        }

        @Override
        protected MapperS<Boolean> isEnabled(List<? extends MicData> preEnriched, String mic) {
            MapperC thenArg0 = MapperC.of(preEnriched).filterItemNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("getMic", micData -> micData.getMic())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getMicValidation", micData -> micData.getMicValidation()));
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)mic)).and(ExpressionOperators.exists(this.preEnrichedMicData(preEnriched, mic)).and(ComparisonResult.of((Mapper)MapperS.of((Object)((Boolean)this.preEnrichedMicData(preEnriched, mic).map("getMicValidation", micData -> micData.getMicValidation()).getOrDefault((Object)true))))).or(ExpressionOperators.notExists(this.preEnrichedMicData(preEnriched, mic)).and(ComparisonResult.of((Mapper)MapperS.of((Object)((Boolean)MapperS.of((Object)((Boolean)ExpressionOperators.distinct((Mapper)thenArg1).get())).getOrDefault((Object)true))))))).asMapper();
        }
    }
}

