/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.array;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.function.DoubleTernaryOperator;
import com.opengamma.strata.collect.function.IntDoubleConsumer;
import com.opengamma.strata.collect.function.IntDoubleToDoubleFunction;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class DoubleArray
implements Matrix,
ImmutableBean,
Serializable {
    public static final DoubleArray EMPTY = new DoubleArray(new double[0]);
    private static final long serialVersionUID = 1L;
    private final double[] array;

    public static DoubleArray of() {
        return EMPTY;
    }

    public static DoubleArray of(double value) {
        return new DoubleArray(new double[]{value});
    }

    public static DoubleArray of(double value1, double value2) {
        return new DoubleArray(new double[]{value1, value2});
    }

    public static DoubleArray of(double value1, double value2, double value3) {
        return new DoubleArray(new double[]{value1, value2, value3});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4) {
        return new DoubleArray(new double[]{value1, value2, value3, value4});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4, double value5) {
        return new DoubleArray(new double[]{value1, value2, value3, value4, value5});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4, double value5, double value6) {
        return new DoubleArray(new double[]{value1, value2, value3, value4, value5, value6});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4, double value5, double value6, double value7) {
        return new DoubleArray(new double[]{value1, value2, value3, value4, value5, value6, value7});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8) {
        return new DoubleArray(new double[]{value1, value2, value3, value4, value5, value6, value7, value8});
    }

    public static DoubleArray of(double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double ... otherValues) {
        double[] base = new double[otherValues.length + 8];
        base[0] = value1;
        base[1] = value2;
        base[2] = value3;
        base[3] = value4;
        base[4] = value5;
        base[5] = value6;
        base[6] = value7;
        base[7] = value8;
        System.arraycopy(otherValues, 0, base, 8, otherValues.length);
        return new DoubleArray(base);
    }

    public static DoubleArray of(int size, IntToDoubleFunction valueFunction) {
        if (size == 0) {
            return EMPTY;
        }
        double[] array = new double[size];
        Arrays.setAll(array, valueFunction);
        return new DoubleArray(array);
    }

    public static DoubleArray of(DoubleStream stream) {
        return DoubleArray.ofUnsafe(stream.toArray());
    }

    public static DoubleArray ofUnsafe(double[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new DoubleArray(array);
    }

    public static DoubleArray copyOf(Collection<Double> collection) {
        if (collection.size() == 0) {
            return EMPTY;
        }
        if (collection instanceof ImmList) {
            return ((ImmList)collection).underlying;
        }
        return new DoubleArray(Doubles.toArray(collection));
    }

    public static DoubleArray copyOf(double[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new DoubleArray((double[])array.clone());
    }

    public static DoubleArray copyOf(double[] array, int fromIndex) {
        return DoubleArray.copyOf(array, fromIndex, array.length);
    }

    public static DoubleArray copyOf(double[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new DoubleArray(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static DoubleArray filled(int size) {
        if (size == 0) {
            return EMPTY;
        }
        return new DoubleArray(new double[size]);
    }

    public static DoubleArray filled(int size, double value) {
        if (size == 0) {
            return EMPTY;
        }
        double[] array = new double[size];
        Arrays.fill(array, value);
        return new DoubleArray(array);
    }

    private DoubleArray(double[] array) {
        this.array = array;
    }

    @Override
    public int dimensions() {
        return 1;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public double get(int index) {
        return this.array[index];
    }

    public boolean contains(double value) {
        if (this.array.length > 0) {
            long bits = Double.doubleToLongBits(value);
            for (int i = 0; i < this.array.length; ++i) {
                if (Double.doubleToLongBits(this.array[i]) != bits) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(double value) {
        if (this.array.length > 0) {
            long bits = Double.doubleToLongBits(value);
            for (int i = 0; i < this.array.length; ++i) {
                if (Double.doubleToLongBits(this.array[i]) != bits) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        if (this.array.length > 0) {
            long bits = Double.doubleToLongBits(value);
            for (int i = this.array.length - 1; i >= 0; --i) {
                if (Double.doubleToLongBits(this.array[i]) != bits) continue;
                return i;
            }
        }
        return -1;
    }

    public void copyInto(double[] destination, int offset) {
        if (destination.length < this.array.length + offset) {
            throw new IndexOutOfBoundsException("Destination array is not large enough");
        }
        System.arraycopy(this.array, 0, destination, offset, this.array.length);
    }

    public DoubleArray subArray(int fromIndexInclusive) {
        return this.subArray(fromIndexInclusive, this.array.length);
    }

    public DoubleArray subArray(int fromIndexInclusive, int toIndexExclusive) {
        return DoubleArray.copyOf(this.array, fromIndexInclusive, toIndexExclusive);
    }

    public double[] toArray() {
        return (double[])this.array.clone();
    }

    public double[] toArrayUnsafe() {
        return this.array;
    }

    public List<Double> toList() {
        return new ImmList(this);
    }

    public DoubleStream stream() {
        return DoubleStream.of(this.array);
    }

    public void forEach(IntDoubleConsumer action) {
        for (int i = 0; i < this.array.length; ++i) {
            action.accept(i, this.array[i]);
        }
    }

    public DoubleArray with(int index, double newValue) {
        if (Double.doubleToLongBits(this.array[index]) == Double.doubleToLongBits(newValue)) {
            return this;
        }
        double[] result = (double[])this.array.clone();
        result[index] = newValue;
        return new DoubleArray(result);
    }

    public DoubleArray plus(double amount) {
        if (amount == 0.0) {
            return this;
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + amount;
        }
        return new DoubleArray(result);
    }

    public DoubleArray minus(double amount) {
        if (amount == 0.0) {
            return this;
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - amount;
        }
        return new DoubleArray(result);
    }

    public DoubleArray multipliedBy(double factor) {
        if (factor == 1.0) {
            return this;
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * factor;
        }
        return new DoubleArray(result);
    }

    public DoubleArray dividedBy(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        double factor = 1.0 / divisor;
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * factor;
        }
        return new DoubleArray(result);
    }

    public DoubleArray map(DoubleUnaryOperator operator) {
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsDouble(this.array[i]);
        }
        return new DoubleArray(result);
    }

    public DoubleArray mapWithIndex(IntDoubleToDoubleFunction function) {
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = function.applyAsDouble(i, this.array[i]);
        }
        return new DoubleArray(result);
    }

    public DoubleArray plus(DoubleArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + other.array[i];
        }
        return new DoubleArray(result);
    }

    public DoubleArray minus(DoubleArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - other.array[i];
        }
        return new DoubleArray(result);
    }

    public DoubleArray multipliedBy(DoubleArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * other.array[i];
        }
        return new DoubleArray(result);
    }

    public DoubleArray dividedBy(DoubleArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] / other.array[i];
        }
        return new DoubleArray(result);
    }

    public DoubleArray combine(DoubleArray other, DoubleBinaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsDouble(this.array[i], other.array[i]);
        }
        return new DoubleArray(result);
    }

    public double combineReduce(DoubleArray other, DoubleTernaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double result = 0.0;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsDouble(result, this.array[i], other.array[i]);
        }
        return result;
    }

    public DoubleArray concat(double ... arrayToConcat) {
        if (this.array.length == 0) {
            return DoubleArray.copyOf(arrayToConcat);
        }
        if (arrayToConcat.length == 0) {
            return this;
        }
        double[] result = new double[this.array.length + arrayToConcat.length];
        System.arraycopy(this.array, 0, result, 0, this.array.length);
        System.arraycopy(arrayToConcat, 0, result, this.array.length, arrayToConcat.length);
        return new DoubleArray(result);
    }

    public DoubleArray concat(DoubleArray arrayToConcat) {
        if (this.array.length == 0) {
            return arrayToConcat;
        }
        if (arrayToConcat.array.length == 0) {
            return this;
        }
        return this.concat(arrayToConcat.array);
    }

    public DoubleArray sorted() {
        if (this.array.length < 2) {
            return this;
        }
        double[] result = (double[])this.array.clone();
        Arrays.sort(result);
        return new DoubleArray(result);
    }

    public double min() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find minimum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.array.length; ++i) {
            min = Math.min(min, this.array[i]);
        }
        return min;
    }

    public double max() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find maximum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.array.length; ++i) {
            max = Math.max(max, this.array[i]);
        }
        return max;
    }

    public double sum() {
        double total = 0.0;
        for (int i = 0; i < this.array.length; ++i) {
            total += this.array[i];
        }
        return total;
    }

    public double reduce(double identity, DoubleBinaryOperator operator) {
        double result = identity;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsDouble(result, this.array[i]);
        }
        return result;
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    public <R> Property<R> property(String propertyName) {
        return this.metaBean().metaProperty(propertyName).createProperty((Bean)this);
    }

    public Set<String> propertyNames() {
        return this.metaBean().metaPropertyMap().keySet();
    }

    public boolean equalWithTolerance(DoubleArray other, double tolerance) {
        return DoubleArrayMath.fuzzyEquals(this.array, other.array, tolerance);
    }

    public boolean equalZeroWithTolerance(double tolerance) {
        return DoubleArrayMath.fuzzyEqualsZero(this.array, tolerance);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DoubleArray) {
            DoubleArray other = (DoubleArray)obj;
            return Arrays.equals(this.array, other.array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<double[]> ARRAY = new BasicMetaProperty<double[]>("array"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return DoubleArray.class;
            }

            public Class<double[]> propertyType() {
                return double[].class;
            }

            public Type propertyGenericType() {
                return double[].class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public double[] get(Bean bean) {
                return ((DoubleArray)bean).toArray();
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"array", ARRAY);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<DoubleArray> builder() {
            return new BasicImmutableBeanBuilder<DoubleArray>((MetaBean)this){
                private double[] array;
                {
                    super(x0);
                    this.array = DoubleArrayMath.EMPTY_DOUBLE_ARRAY;
                }

                public Object get(String propertyName) {
                    if (propertyName.equals(ARRAY.name())) {
                        return this.array.clone();
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<DoubleArray> set(String propertyName, Object value) {
                    if (!propertyName.equals(ARRAY.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.array = (double[])((double[])ArgChecker.notNull(value, "value")).clone();
                    return this;
                }

                public DoubleArray build() {
                    return new DoubleArray(this.array);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return DoubleArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }

    static class ImmList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DoubleArray underlying;

        ImmList(DoubleArray underlying) {
            this.underlying = underlying;
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public Double get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public boolean contains(Object obj) {
            return obj instanceof Double ? this.underlying.contains((Double)obj) : false;
        }

        @Override
        public int indexOf(Object obj) {
            return obj instanceof Double ? this.underlying.indexOf((Double)obj) : -1;
        }

        @Override
        public int lastIndexOf(Object obj) {
            return obj instanceof Double ? this.underlying.lastIndexOf((Double)obj) : -1;
        }

        @Override
        public ListIterator<Double> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Double> listIterator() {
            return new ImmIterator(this.underlying.array);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Unable to remove range from DoubleArray");
        }
    }

    static class ImmIterator
    implements ListIterator<Double> {
        private final double[] array;
        private int index;

        public ImmIterator(double[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Double next() {
            if (this.hasNext()) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException("Iteration has reached the last element");
        }

        @Override
        public Double previous() {
            if (this.hasPrevious()) {
                return this.array[--this.index];
            }
            throw new NoSuchElementException("Iteration has reached the first element");
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from DoubleArray");
        }

        @Override
        public void set(Double value) {
            throw new UnsupportedOperationException("Unable to set value in DoubleArray");
        }

        @Override
        public void add(Double value) {
            throw new UnsupportedOperationException("Unable to add value to DoubleArray");
        }
    }
}

