/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.CsvRow;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class CsvFile {
    private final ImmutableList<String> headers;
    private final ImmutableList<CsvRow> rows;

    public static CsvFile of(CharSource source, boolean headerRow) {
        return CsvFile.of(source, headerRow, ',');
    }

    public static CsvFile of(CharSource source, boolean headerRow, char separator) {
        ArgChecker.notNull(source, "source");
        List lines = (List)Unchecked.wrap(() -> source.readLines());
        return CsvFile.create(lines, headerRow, separator);
    }

    public static CsvFile of(Reader reader, boolean headerRow) {
        return CsvFile.of(reader, headerRow, ',');
    }

    public static CsvFile of(Reader reader, boolean headerRow, char separator) {
        ArgChecker.notNull(reader, "source");
        List lines = Unchecked.wrap(() -> CharStreams.readLines((Readable)reader));
        return CsvFile.create(lines, headerRow, separator);
    }

    private static CsvFile create(List<String> lines, boolean headerRow, char separator) {
        if (headerRow) {
            for (int i = 0; i < lines.size(); ++i) {
                ImmutableList<String> headers = CsvFile.parseLine(lines.get(i), i + 1, separator);
                if (headers.isEmpty()) continue;
                ImmutableMap<String, Integer> searchHeaders = CsvFile.buildSearchHeaders(headers);
                return CsvFile.parseAll(lines, i + 1, separator, headers, searchHeaders);
            }
            throw new IllegalArgumentException("Could not read header row from empty CSV file");
        }
        return CsvFile.parseAll(lines, 0, separator, (ImmutableList<String>)ImmutableList.of(), (ImmutableMap<String, Integer>)ImmutableMap.of());
    }

    public static CsvFile of(List<String> headers, List<? extends List<String>> rows) {
        int size;
        ArgChecker.notNull(headers, "headers");
        ArgChecker.notNull(rows, "rows");
        int n = size = headers.size() == 0 && rows.size() > 0 ? rows.get(0).size() : headers.size();
        if (rows.stream().filter(row -> row.size() != size).findAny().isPresent()) {
            throw new IllegalArgumentException("Invalid data rows, each row must have same columns as header row");
        }
        ImmutableList copiedHeaders = ImmutableList.copyOf(headers);
        ImmutableMap<String, Integer> searchHeaders = CsvFile.buildSearchHeaders((ImmutableList<String>)copiedHeaders);
        ImmutableList.Builder csvRows = ImmutableList.builder();
        int firstLine = copiedHeaders.isEmpty() ? 1 : 2;
        for (int i = 0; i < rows.size(); ++i) {
            csvRows.add((Object)new CsvRow((ImmutableList<String>)copiedHeaders, searchHeaders, i + firstLine, (ImmutableList<String>)ImmutableList.copyOf((Collection)rows.get(i))));
        }
        return new CsvFile((ImmutableList<String>)copiedHeaders, (ImmutableList<CsvRow>)csvRows.build());
    }

    private static CsvFile parseAll(List<String> lines, int lineIndex, char separator, ImmutableList<String> headers, ImmutableMap<String, Integer> searchHeaders) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int i = lineIndex; i < lines.size(); ++i) {
            ImmutableList<String> fields = CsvFile.parseLine(lines.get(i), i + 1, separator);
            if (fields.isEmpty()) continue;
            rows.add((Object)new CsvRow(headers, searchHeaders, i + 1, fields));
        }
        return new CsvFile(headers, (ImmutableList<CsvRow>)rows.build());
    }

    static ImmutableList<String> parseLine(String line, int lineNumber, char separator) {
        if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int start = 0;
        String terminated = line + separator;
        int nextSeparator = terminated.indexOf(separator, start);
        while (nextSeparator >= 0) {
            String possible = terminated.substring(start, nextSeparator).trim();
            if (possible.startsWith("=\"")) {
                ++start;
                possible = possible.substring(1);
            }
            if (possible.startsWith("\"")) {
                while (true) {
                    if (possible.substring(1).replace("\"\"", "").endsWith("\"")) {
                        possible = possible.substring(1, possible.length() - 1).replace("\"\"", "\"");
                        break;
                    }
                    if ((nextSeparator = terminated.indexOf(separator, nextSeparator + 1)) < 0) {
                        throw new IllegalArgumentException("Mismatched quotes in CSV on line " + lineNumber);
                    }
                    possible = terminated.substring(start, nextSeparator).trim();
                }
            }
            builder.add((Object)possible);
            start = nextSeparator + 1;
            nextSeparator = terminated.indexOf(separator, start);
        }
        ImmutableList fields = builder.build();
        if (!CsvFile.hasContent((ImmutableList<String>)fields)) {
            return ImmutableList.of();
        }
        return fields;
    }

    private static boolean hasContent(ImmutableList<String> fields) {
        for (String field : fields) {
            if (field.trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static ImmutableMap<String, Integer> buildSearchHeaders(ImmutableList<String> headers) {
        HashMap<String, Integer> searchHeaders = new HashMap<String, Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            String searchHeader = ((String)headers.get(i)).toLowerCase(Locale.ENGLISH);
            searchHeaders.putIfAbsent(searchHeader, i);
        }
        return ImmutableMap.copyOf(searchHeaders);
    }

    private CsvFile(ImmutableList<String> headers, ImmutableList<CsvRow> rows) {
        this.headers = headers;
        this.rows = rows;
    }

    public ImmutableList<String> headers() {
        return this.headers;
    }

    public ImmutableList<CsvRow> rows() {
        return this.rows;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public CsvRow row(int index) {
        return (CsvRow)this.rows.get(index);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CsvFile) {
            CsvFile other = (CsvFile)obj;
            return this.headers.equals(other.headers) && this.rows.equals(other.rows);
        }
        return false;
    }

    public int hashCode() {
        return this.headers.hashCode() ^ this.rows.hashCode();
    }

    public String toString() {
        return "CsvFile" + this.headers.toString();
    }
}

