package iso20022.auth030.asic.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.asic.InterestRateLegs14__2;
import iso20022.auth030.asic.validation.InterestRateLegs14__2TypeFormatValidator;
import iso20022.auth030.asic.validation.InterestRateLegs14__2Validator;
import iso20022.auth030.asic.validation.exists.InterestRateLegs14__2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=InterestRateLegs14__2.class)
public class InterestRateLegs14__2Meta implements RosettaMetaData<InterestRateLegs14__2> {

	@Override
	public List<Validator<? super InterestRateLegs14__2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super InterestRateLegs14__2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super InterestRateLegs14__2> validator(ValidatorFactory factory) {
		return factory.<InterestRateLegs14__2>create(InterestRateLegs14__2Validator.class);
	}

	@Override
	public Validator<? super InterestRateLegs14__2> typeFormatValidator(ValidatorFactory factory) {
		return factory.<InterestRateLegs14__2>create(InterestRateLegs14__2TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super InterestRateLegs14__2> validator() {
		return new InterestRateLegs14__2Validator();
	}

	@Deprecated
	@Override
	public Validator<? super InterestRateLegs14__2> typeFormatValidator() {
		return new InterestRateLegs14__2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super InterestRateLegs14__2, Set<String>> onlyExistsValidator() {
		return new InterestRateLegs14__2OnlyExistsValidator();
	}
}
