package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.SupplementaryDataEnvelope1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SupplementaryDataEnvelope1Validator implements Validator<SupplementaryDataEnvelope1> {

	private List<ComparisonResult> getComparisonResults(SupplementaryDataEnvelope1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("anyContents", (String) o.getAnyContents() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SupplementaryDataEnvelope1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SupplementaryDataEnvelope1", ValidationResult.ValidationType.CARDINALITY, "SupplementaryDataEnvelope1", path, "", res.getError());
				}
				return success("SupplementaryDataEnvelope1", ValidationResult.ValidationType.CARDINALITY, "SupplementaryDataEnvelope1", path, "");
			})
			.collect(toList());
	}

}
