# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.TradeState import TradeState
from cdm.base.math.Quantity import Quantity
from cdm.product.common.settlement.TransferSettlementEnum import TransferSettlementEnum
from cdm.event.common.Transfer import Transfer

__all__ = ['Create_SecurityTransfer']


@replaceable
def Create_SecurityTransfer(tradeState: TradeState, date: datetime.date, quantity: Quantity | None) -> Transfer:
    """
    Defines the creation of a Transfer, given a Trade State and date.
    
    Parameters 
    ----------
    tradeState : TradeState
    
    date : date
    
    quantity : Quantity
    Specifies quantity amount returned if not the full amount from the TradeState, e.g. partial return
    
    Returns
    -------
    transfer : Transfer
    
    """
    _post_registry = {}
    self = inspect.currentframe()
    
    
    transfer = rosetta_resolve_attr(self, "transfer")
    
    # post-conditions
    
    @rosetta_local_condition(_post_registry)
    def condition_0_UnitsAndObservable(self):
        def _then_fn0():
            return (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "transfer"), "quantity"), "unit"), "currency")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "transfer"), "observable"), "productIdentifier")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradableProduct"), "product"), "security")) and all_elements(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradableProduct"), "tradeLot"), "priceQuantity"), "settlementTerms"), "transferSettlementType")), "=", rosetta_resolve_attr(TransferSettlementEnum, "DELIVERY_VERSUS_PAYMENT"))), _then_fn0, _else_fn0)
    # Execute all registered post-conditions
    execute_local_conditions(_post_registry, 'Post-condition')
    
    return transfer

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
