# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.functions.UpdateAmount import UpdateAmount
from cdm.base.math.NonNegativeQuantitySchedule import NonNegativeQuantitySchedule
from cdm.base.math.functions.UnitEquals import UnitEquals
from cdm.base.math.QuantityChangeDirectionEnum import QuantityChangeDirectionEnum

__all__ = ['UpdateQuantityAmountForEachMatchingQuantity']


@replaceable
def UpdateQuantityAmountForEachMatchingQuantity(quantity: NonNegativeQuantitySchedule | None, change: list[NonNegativeQuantitySchedule] | None, direction: QuantityChangeDirectionEnum) -> NonNegativeQuantitySchedule:
    """
    Updates any quantity from the NonNegativeQuantitySchedule list if the unit of amount matches.
    
    Parameters 
    ----------
    quantity : NonNegativeQuantitySchedule
    List of NonNegativeQuantitySchedule to update.
    
    change : NonNegativeQuantitySchedule
    List of new NonNegativeQuantitySchedule to use where the units match.
    
    direction : QuantityChangeDirectionEnum
    Enum specifying how the updated amounts should be applied, e.g., add, subtract or replace.
    
    Returns
    -------
    updatedQuantity : NonNegativeQuantitySchedule
    
    """
    self = inspect.currentframe()
    
    
    changedAmount = (lambda item: list(map(lambda item: UpdateAmount(rosetta_resolve_attr(rosetta_resolve_attr(self, "quantity"), "value"), rosetta_resolve_attr(item, "value"), rosetta_resolve_attr(self, "direction")), item)))((lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(self, "change"), lambda item: UnitEquals(rosetta_resolve_attr(item, "unit"), rosetta_resolve_attr(rosetta_resolve_attr(self, "quantity"), "unit")))))
    updatedQuantity =  rosetta_resolve_attr(self, "quantity")
    updatedQuantity = _get_rosetta_object('NonNegativeQuantitySchedule', 'value', (rosetta_resolve_attr(self, "changedAmount") default rosetta_resolve_attr(rosetta_resolve_attr(self, "quantity"), "value")))
    
    
    return updatedQuantity

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
