# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AssetPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class AssetPayout(PayoutBase):
    """
    Security finance payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction. Plus additional description for ICMA.
    """
    assetLeg: List[cdm.product.template.AssetLeg.AssetLeg] = Field([], description="Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.")
    """
    Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
    """
    @rosetta_condition
    def cardinality_assetLeg(self):
        return check_cardinality(self.assetLeg, 1, None)
    
    securityInformation: cdm.product.template.Product.Product = Field(..., description="Specifies the Purchased Security. Within SecurityPayout we include a condition which validates that the product must be a Security (see below condition 'ProductMustBeSecurity').")
    """
    Specifies the Purchased Security.  Within SecurityPayout we include a condition which validates that the product must be a Security (see below condition 'ProductMustBeSecurity').
    """
    durationType: cdm.product.template.Duration.Duration = Field(..., description="Specifies the Duration Terms of the Security Finance transaction. e.g. Open or Term.")
    """
    Specifies the Duration Terms of the Security Finance transaction. e.g. Open or Term.
    """
    minimumFee: Optional[cdm.observable.asset.Money.Money] = Field(None, description="A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.")
    """
    A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.
    """
    dividendTerms: Optional[cdm.product.template.DividendTerms.DividendTerms] = Field(None, description="Specifies the terms under which dividends received by the borrower are passed through to the lender.")
    """
    Specifies the terms under which dividends received by the borrower are passed through to the lender.
    """
    
    @rosetta_condition
    def condition_0_Quantity(self):
        """
        When there is an OptionPayout the quantity can be expressed as part of the payoutQuantity, or as part of the underlier in the case of a Swaption.  For all other payouts that extend PayoutBase the payoutQuantity is a mandatory attribute.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(self, "priceQuantity"))
    
    @rosetta_condition
    def condition_1_ProductMustBeSecurity(self):
        """
        Validates that the Purchased Security must be a security.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "securityInformation"), "security"))
    
    @rosetta_condition
    def condition_2_DividendTermsValidation(self):
        """
        Validates that if the transaction has Dividend Terms specified then the Duration should be Term.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "durationType"), "durationType"), "=", rosetta_resolve_attr(DurationTypeEnum, "TERM"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "dividendTerms")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.AssetLeg
import cdm.product.template.Product
import cdm.product.template.Duration
import cdm.observable.asset.Money
import cdm.product.template.DividendTerms
from cdm.product.template.DurationTypeEnum import DurationTypeEnum
