package drr.enrichment.upi.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.enrichment.upi.AnnaDsbUpiRequestAndType;
import drr.enrichment.upi.AnnaDsbUpiRequestTypeEnum;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_AnnaDsbUpiRequestFromReportableEvent.Create_AnnaDsbUpiRequestFromReportableEventDefault.class)
public abstract class Create_AnnaDsbUpiRequestFromReportableEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_AnnaDsbUpiRequestFromReportableEventAndUnderlying create_AnnaDsbUpiRequestFromReportableEventAndUnderlying;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return request 
	*/
	public AnnaDsbUpiRequestAndType evaluate(ReportableEvent reportableEvent) {
		AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder requestBuilder = doEvaluate(reportableEvent);
		
		final AnnaDsbUpiRequestAndType request;
		if (requestBuilder == null) {
			request = null;
		} else {
			request = requestBuilder.build();
			objectValidator.validate(AnnaDsbUpiRequestAndType.class, request);
		}
		
		return request;
	}

	protected abstract AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> isSwaption(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> underlyingRequestNeeded(ReportableEvent reportableEvent);

	public static class Create_AnnaDsbUpiRequestFromReportableEventDefault extends Create_AnnaDsbUpiRequestFromReportableEvent {
		@Override
		protected AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder doEvaluate(ReportableEvent reportableEvent) {
			AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder request = AnnaDsbUpiRequestAndType.builder();
			return assignOutput(request, reportableEvent);
		}
		
		protected AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder assignOutput(AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder request, ReportableEvent reportableEvent) {
			final AnnaDsbUpiRequestTypeEnum ifThenElseResult;
			if (underlyingRequestNeeded(reportableEvent).getOrDefault(false)) {
				ifThenElseResult = AnnaDsbUpiRequestTypeEnum.UNDERLYING_PRODUCT_REQUEST;
			} else {
				ifThenElseResult = AnnaDsbUpiRequestTypeEnum.PRODUCT_REQUEST;
			}
			request
				.setRequestType(ifThenElseResult);
			
			request
				.setRequest(create_AnnaDsbUpiRequestFromReportableEventAndUnderlying.evaluate(reportableEvent));
			
			return Optional.ofNullable(request)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
		}
		
		@Override
		protected MapperS<Boolean> isSwaption(ReportableEvent reportableEvent) {
			final MapperS<? extends Product> thenArg = product(reportableEvent);
			return ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(thenArg.get()))).or(ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(thenArg.get())))).asMapper();
		}
		
		@Override
		protected MapperS<Boolean> underlyingRequestNeeded(ReportableEvent reportableEvent) {
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg = MapperS.of(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())
				.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.UPI), CardinalityOperator.All).get());
			return ComparisonResult.of(isSwaption(reportableEvent)).and(ComparisonResult.of(notExists(thenArg).asMapper())).asMapper();
		}
	}
}
