package drr.regulation.asic.rewrite.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.17
 */
@RosettaDataRule("ASICMarginReportDTCC_ASIC_BR_3011_02")
@ImplementedBy(ASICMarginReportDTCC_ASIC_BR_3011_02.Default.class)
public interface ASICMarginReportDTCC_ASIC_BR_3011_02 extends Validator<ASICMarginReport> {
	
	String NAME = "ASICMarginReportDTCC_ASIC_BR_3011_02";
	String DEFINITION = "if actionType = MarginActionEnum -> MARU or actionType = MarginActionEnum -> CORR and initialMarginCollateralPortfolioCode = \"NOAP\" and (uniqueTransactionIdentifier is absent and uniqueTransactionIdentifierProprietary is absent) then variationMarginCollectedByTheReportingEntityPreHaircut exists else if (uniqueTransactionIdentifier exists or uniqueTransactionIdentifierProprietary exists) and collateralPortfolioCodeVM <> \"NOAP\" or initialMarginCollateralPortfolioCode = \"NOAP\" then collateralPortfolioCodeVM is absent";
	
	class Default implements ASICMarginReportDTCC_ASIC_BR_3011_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport aSICMarginReport) {
			ComparisonResult result = executeDataRule(aSICMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICMarginReport aSICMarginReport) {
			try {
				if (areEqual(MapperS.of(aSICMarginReport).<MarginActionEnum>map("getActionType", _aSICMarginReport -> _aSICMarginReport.getActionType()), MapperS.of(MarginActionEnum.MARU), CardinalityOperator.All).or(areEqual(MapperS.of(aSICMarginReport).<MarginActionEnum>map("getActionType", _aSICMarginReport -> _aSICMarginReport.getActionType()), MapperS.of(MarginActionEnum.CORR), CardinalityOperator.All).and(areEqual(MapperS.of(aSICMarginReport).<String>map("getInitialMarginCollateralPortfolioCode", _aSICMarginReport -> _aSICMarginReport.getInitialMarginCollateralPortfolioCode()), MapperS.of("NOAP"), CardinalityOperator.All)).and(notExists(MapperS.of(aSICMarginReport).<String>map("getUniqueTransactionIdentifier", _aSICMarginReport -> _aSICMarginReport.getUniqueTransactionIdentifier())).and(notExists(MapperS.of(aSICMarginReport).<String>map("getUniqueTransactionIdentifierProprietary", _aSICMarginReport -> _aSICMarginReport.getUniqueTransactionIdentifierProprietary()))))).getOrDefault(false)) {
					return exists(MapperS.of(aSICMarginReport).<BigDecimal>map("getVariationMarginCollectedByTheReportingEntityPreHaircut", _aSICMarginReport -> _aSICMarginReport.getVariationMarginCollectedByTheReportingEntityPreHaircut()));
				}
				if (exists(MapperS.of(aSICMarginReport).<String>map("getUniqueTransactionIdentifier", _aSICMarginReport -> _aSICMarginReport.getUniqueTransactionIdentifier())).or(exists(MapperS.of(aSICMarginReport).<String>map("getUniqueTransactionIdentifierProprietary", _aSICMarginReport -> _aSICMarginReport.getUniqueTransactionIdentifierProprietary()))).and(notEqual(MapperS.of(aSICMarginReport).<String>map("getCollateralPortfolioCodeVM", _aSICMarginReport -> _aSICMarginReport.getCollateralPortfolioCodeVM()), MapperS.of("NOAP"), CardinalityOperator.Any)).or(areEqual(MapperS.of(aSICMarginReport).<String>map("getInitialMarginCollateralPortfolioCode", _aSICMarginReport -> _aSICMarginReport.getInitialMarginCollateralPortfolioCode()), MapperS.of("NOAP"), CardinalityOperator.All)).getOrDefault(false)) {
					return notExists(MapperS.of(aSICMarginReport).<String>map("getCollateralPortfolioCodeVM", _aSICMarginReport -> _aSICMarginReport.getCollateralPortfolioCodeVM()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICMarginReportDTCC_ASIC_BR_3011_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport aSICMarginReport) {
			return Collections.emptyList();
		}
	}
}
