package drr.regulation.common;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.meta.CommonCollateralReportMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Common Margin Report represents common Margin report attributes
 * @version 7.0.0-dev.17
 */
@RosettaDataType(value="CommonCollateralReport", builder=CommonCollateralReport.CommonCollateralReportBuilderImpl.class, version="7.0.0-dev.17")
@RuneDataType(value="CommonCollateralReport", model="drr", builder=CommonCollateralReport.CommonCollateralReportBuilderImpl.class, version="7.0.0-dev.17")
public interface CommonCollateralReport extends RosettaModelObject {

	CommonCollateralReportMeta metaData = new CommonCollateralReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUti();
	Boolean getCollateralPortfolioIndicator();
	CollateralisationType3Code__1 getCollateralisationCategory();
	BigDecimal getInitialMarginPostedByTheCounterparty1PreHaircut();
	BigDecimal getInitialMarginPostedByTheCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency();
	BigDecimal getVariationMarginPostedByTheCounterparty1PreHaircut();
	BigDecimal getVariationMarginPostedByTheCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency();
	BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut();
	BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency();
	BigDecimal getVariationMarginCollectedByTheCounterparty1PreHaircut();
	BigDecimal getVariationMarginCollectedByTheCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency();
	BigDecimal getExcessCollateralPostedByTheCounterparty1();
	String getCurrencyOfTheExcessCollateralPosted();
	BigDecimal getExcessCollateralCollectedByTheCounterparty1();
	String getCurrencyOfTheExcessCollateralCollected();
	MarginActionEnum getActionType();
	Date getEventDate();

	/*********************** Build Methods  ***********************/
	CommonCollateralReport build();
	
	CommonCollateralReport.CommonCollateralReportBuilder toBuilder();
	
	static CommonCollateralReport.CommonCollateralReportBuilder builder() {
		return new CommonCollateralReport.CommonCollateralReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonCollateralReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonCollateralReport> getType() {
		return CommonCollateralReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByTheCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByTheCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginPostedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByTheCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByTheCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginPostedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginCollectedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginCollectedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, getExcessCollateralPostedByTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, getCurrencyOfTheExcessCollateralPosted(), this);
		processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonCollateralReportBuilder extends CommonCollateralReport, RosettaModelObjectBuilder {
		CommonCollateralReport.CommonCollateralReportBuilder setUti(String uti);
		CommonCollateralReport.CommonCollateralReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		CommonCollateralReport.CommonCollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 collateralisationCategory);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal initialMarginPostedByTheCounterparty1PreHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal initialMarginPostedByTheCounterparty1PostHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal variationMarginPostedByTheCounterparty1PreHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal variationMarginPostedByTheCounterparty1PostHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal initialMarginCollectedByCounterparty1PreHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal initialMarginCollectedByCounterparty1PostHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal variationMarginCollectedByTheCounterparty1PreHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal variationMarginCollectedByTheCounterparty1PostHaircut);
		CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency);
		CommonCollateralReport.CommonCollateralReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal excessCollateralPostedByTheCounterparty1);
		CommonCollateralReport.CommonCollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String currencyOfTheExcessCollateralPosted);
		CommonCollateralReport.CommonCollateralReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal excessCollateralCollectedByTheCounterparty1);
		CommonCollateralReport.CommonCollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String currencyOfTheExcessCollateralCollected);
		CommonCollateralReport.CommonCollateralReportBuilder setActionType(MarginActionEnum actionType);
		CommonCollateralReport.CommonCollateralReportBuilder setEventDate(Date eventDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByTheCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByTheCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginPostedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByTheCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByTheCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginPostedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginCollectedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginCollectedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, getExcessCollateralPostedByTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, getCurrencyOfTheExcessCollateralPosted(), this);
			processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		}
		

		CommonCollateralReport.CommonCollateralReportBuilder prune();
	}

	/*********************** Immutable Implementation of CommonCollateralReport  ***********************/
	class CommonCollateralReportImpl implements CommonCollateralReport {
		private final String uti;
		private final Boolean collateralPortfolioIndicator;
		private final CollateralisationType3Code__1 collateralisationCategory;
		private final BigDecimal initialMarginPostedByTheCounterparty1PreHaircut;
		private final BigDecimal initialMarginPostedByTheCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency;
		private final BigDecimal variationMarginPostedByTheCounterparty1PreHaircut;
		private final BigDecimal variationMarginPostedByTheCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency;
		private final BigDecimal initialMarginCollectedByCounterparty1PreHaircut;
		private final BigDecimal initialMarginCollectedByCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency;
		private final BigDecimal variationMarginCollectedByTheCounterparty1PreHaircut;
		private final BigDecimal variationMarginCollectedByTheCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency;
		private final BigDecimal excessCollateralPostedByTheCounterparty1;
		private final String currencyOfTheExcessCollateralPosted;
		private final BigDecimal excessCollateralCollectedByTheCounterparty1;
		private final String currencyOfTheExcessCollateralCollected;
		private final MarginActionEnum actionType;
		private final Date eventDate;
		
		protected CommonCollateralReportImpl(CommonCollateralReport.CommonCollateralReportBuilder builder) {
			this.uti = builder.getUti();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.initialMarginPostedByTheCounterparty1PreHaircut = builder.getInitialMarginPostedByTheCounterparty1PreHaircut();
			this.initialMarginPostedByTheCounterparty1PostHaircut = builder.getInitialMarginPostedByTheCounterparty1PostHaircut();
			this.initialMarginPostedByCounterparty1Currency = builder.getInitialMarginPostedByCounterparty1Currency();
			this.variationMarginPostedByTheCounterparty1PreHaircut = builder.getVariationMarginPostedByTheCounterparty1PreHaircut();
			this.variationMarginPostedByTheCounterparty1PostHaircut = builder.getVariationMarginPostedByTheCounterparty1PostHaircut();
			this.variationMarginPostedByCounterparty1Currency = builder.getVariationMarginPostedByCounterparty1Currency();
			this.initialMarginCollectedByCounterparty1PreHaircut = builder.getInitialMarginCollectedByCounterparty1PreHaircut();
			this.initialMarginCollectedByCounterparty1PostHaircut = builder.getInitialMarginCollectedByCounterparty1PostHaircut();
			this.initialMarginCollectedByCounterparty1Currency = builder.getInitialMarginCollectedByCounterparty1Currency();
			this.variationMarginCollectedByTheCounterparty1PreHaircut = builder.getVariationMarginCollectedByTheCounterparty1PreHaircut();
			this.variationMarginCollectedByTheCounterparty1PostHaircut = builder.getVariationMarginCollectedByTheCounterparty1PostHaircut();
			this.variationMarginCollectedByCounterparty1Currency = builder.getVariationMarginCollectedByCounterparty1Currency();
			this.excessCollateralPostedByTheCounterparty1 = builder.getExcessCollateralPostedByTheCounterparty1();
			this.currencyOfTheExcessCollateralPosted = builder.getCurrencyOfTheExcessCollateralPosted();
			this.excessCollateralCollectedByTheCounterparty1 = builder.getExcessCollateralCollectedByTheCounterparty1();
			this.currencyOfTheExcessCollateralCollected = builder.getCurrencyOfTheExcessCollateralCollected();
			this.actionType = builder.getActionType();
			this.eventDate = builder.getEventDate();
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByTheCounterparty1PreHaircut() {
			return initialMarginPostedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByTheCounterparty1PostHaircut() {
			return initialMarginPostedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency() {
			return initialMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByTheCounterparty1PreHaircut() {
			return variationMarginPostedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByTheCounterparty1PostHaircut() {
			return variationMarginPostedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency() {
			return variationMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut() {
			return initialMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut() {
			return initialMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency() {
			return initialMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByTheCounterparty1PreHaircut() {
			return variationMarginCollectedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByTheCounterparty1PostHaircut() {
			return variationMarginCollectedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency() {
			return variationMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		public BigDecimal getExcessCollateralPostedByTheCounterparty1() {
			return excessCollateralPostedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		public String getCurrencyOfTheExcessCollateralPosted() {
			return currencyOfTheExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		public BigDecimal getExcessCollateralCollectedByTheCounterparty1() {
			return excessCollateralCollectedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		public CommonCollateralReport build() {
			return this;
		}
		
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder toBuilder() {
			CommonCollateralReport.CommonCollateralReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonCollateralReport.CommonCollateralReportBuilder builder) {
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getInitialMarginPostedByTheCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginPostedByTheCounterparty1PreHaircut);
			ofNullable(getInitialMarginPostedByTheCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginPostedByTheCounterparty1PostHaircut);
			ofNullable(getInitialMarginPostedByCounterparty1Currency()).ifPresent(builder::setInitialMarginPostedByCounterparty1Currency);
			ofNullable(getVariationMarginPostedByTheCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginPostedByTheCounterparty1PreHaircut);
			ofNullable(getVariationMarginPostedByTheCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginPostedByTheCounterparty1PostHaircut);
			ofNullable(getVariationMarginPostedByCounterparty1Currency()).ifPresent(builder::setVariationMarginPostedByCounterparty1Currency);
			ofNullable(getInitialMarginCollectedByCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginCollectedByCounterparty1PreHaircut);
			ofNullable(getInitialMarginCollectedByCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginCollectedByCounterparty1PostHaircut);
			ofNullable(getInitialMarginCollectedByCounterparty1Currency()).ifPresent(builder::setInitialMarginCollectedByCounterparty1Currency);
			ofNullable(getVariationMarginCollectedByTheCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheCounterparty1PreHaircut);
			ofNullable(getVariationMarginCollectedByTheCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginCollectedByTheCounterparty1PostHaircut);
			ofNullable(getVariationMarginCollectedByCounterparty1Currency()).ifPresent(builder::setVariationMarginCollectedByCounterparty1Currency);
			ofNullable(getExcessCollateralPostedByTheCounterparty1()).ifPresent(builder::setExcessCollateralPostedByTheCounterparty1);
			ofNullable(getCurrencyOfTheExcessCollateralPosted()).ifPresent(builder::setCurrencyOfTheExcessCollateralPosted);
			ofNullable(getExcessCollateralCollectedByTheCounterparty1()).ifPresent(builder::setExcessCollateralCollectedByTheCounterparty1);
			ofNullable(getCurrencyOfTheExcessCollateralCollected()).ifPresent(builder::setCurrencyOfTheExcessCollateralCollected);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonCollateralReport _that = getType().cast(o);
		
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(initialMarginPostedByTheCounterparty1PreHaircut, _that.getInitialMarginPostedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheCounterparty1PostHaircut, _that.getInitialMarginPostedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1Currency, _that.getInitialMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginPostedByTheCounterparty1PreHaircut, _that.getVariationMarginPostedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheCounterparty1PostHaircut, _that.getVariationMarginPostedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1Currency, _that.getVariationMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PreHaircut, _that.getInitialMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PostHaircut, _that.getInitialMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1Currency, _that.getInitialMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginCollectedByTheCounterparty1PreHaircut, _that.getVariationMarginCollectedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheCounterparty1PostHaircut, _that.getVariationMarginCollectedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1Currency, _that.getVariationMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(excessCollateralPostedByTheCounterparty1, _that.getExcessCollateralPostedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheCounterparty1, _that.getExcessCollateralCollectedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheCounterparty1PreHaircut != null ? initialMarginPostedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheCounterparty1PostHaircut != null ? initialMarginPostedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1Currency != null ? initialMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheCounterparty1PreHaircut != null ? variationMarginPostedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheCounterparty1PostHaircut != null ? variationMarginPostedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1Currency != null ? variationMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PreHaircut != null ? initialMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PostHaircut != null ? initialMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1Currency != null ? initialMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheCounterparty1PreHaircut != null ? variationMarginCollectedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheCounterparty1PostHaircut != null ? variationMarginCollectedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1Currency != null ? variationMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheCounterparty1 != null ? excessCollateralPostedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralPosted != null ? currencyOfTheExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheCounterparty1 != null ? excessCollateralCollectedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonCollateralReport {" +
				"uti=" + this.uti + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"initialMarginPostedByTheCounterparty1PreHaircut=" + this.initialMarginPostedByTheCounterparty1PreHaircut + ", " +
				"initialMarginPostedByTheCounterparty1PostHaircut=" + this.initialMarginPostedByTheCounterparty1PostHaircut + ", " +
				"initialMarginPostedByCounterparty1Currency=" + this.initialMarginPostedByCounterparty1Currency + ", " +
				"variationMarginPostedByTheCounterparty1PreHaircut=" + this.variationMarginPostedByTheCounterparty1PreHaircut + ", " +
				"variationMarginPostedByTheCounterparty1PostHaircut=" + this.variationMarginPostedByTheCounterparty1PostHaircut + ", " +
				"variationMarginPostedByCounterparty1Currency=" + this.variationMarginPostedByCounterparty1Currency + ", " +
				"initialMarginCollectedByCounterparty1PreHaircut=" + this.initialMarginCollectedByCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByCounterparty1PostHaircut=" + this.initialMarginCollectedByCounterparty1PostHaircut + ", " +
				"initialMarginCollectedByCounterparty1Currency=" + this.initialMarginCollectedByCounterparty1Currency + ", " +
				"variationMarginCollectedByTheCounterparty1PreHaircut=" + this.variationMarginCollectedByTheCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByTheCounterparty1PostHaircut=" + this.variationMarginCollectedByTheCounterparty1PostHaircut + ", " +
				"variationMarginCollectedByCounterparty1Currency=" + this.variationMarginCollectedByCounterparty1Currency + ", " +
				"excessCollateralPostedByTheCounterparty1=" + this.excessCollateralPostedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheCounterparty1=" + this.excessCollateralCollectedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"actionType=" + this.actionType + ", " +
				"eventDate=" + this.eventDate +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonCollateralReport  ***********************/
	class CommonCollateralReportBuilderImpl implements CommonCollateralReport.CommonCollateralReportBuilder {
	
		protected String uti;
		protected Boolean collateralPortfolioIndicator;
		protected CollateralisationType3Code__1 collateralisationCategory;
		protected BigDecimal initialMarginPostedByTheCounterparty1PreHaircut;
		protected BigDecimal initialMarginPostedByTheCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency;
		protected BigDecimal variationMarginPostedByTheCounterparty1PreHaircut;
		protected BigDecimal variationMarginPostedByTheCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency;
		protected BigDecimal initialMarginCollectedByCounterparty1PreHaircut;
		protected BigDecimal initialMarginCollectedByCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency;
		protected BigDecimal variationMarginCollectedByTheCounterparty1PreHaircut;
		protected BigDecimal variationMarginCollectedByTheCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency;
		protected BigDecimal excessCollateralPostedByTheCounterparty1;
		protected String currencyOfTheExcessCollateralPosted;
		protected BigDecimal excessCollateralCollectedByTheCounterparty1;
		protected String currencyOfTheExcessCollateralCollected;
		protected MarginActionEnum actionType;
		protected Date eventDate;
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByTheCounterparty1PreHaircut() {
			return initialMarginPostedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByTheCounterparty1PostHaircut() {
			return initialMarginPostedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency() {
			return initialMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByTheCounterparty1PreHaircut() {
			return variationMarginPostedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByTheCounterparty1PostHaircut() {
			return variationMarginPostedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency() {
			return variationMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut() {
			return initialMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut() {
			return initialMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency() {
			return initialMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByTheCounterparty1PreHaircut() {
			return variationMarginCollectedByTheCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByTheCounterparty1PostHaircut() {
			return variationMarginCollectedByTheCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency() {
			return variationMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		public BigDecimal getExcessCollateralPostedByTheCounterparty1() {
			return excessCollateralPostedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		public String getCurrencyOfTheExcessCollateralPosted() {
			return currencyOfTheExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		public BigDecimal getExcessCollateralCollectedByTheCounterparty1() {
			return excessCollateralCollectedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PreHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
			this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheCounterparty1PostHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
			this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
			this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PreHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
			this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheCounterparty1PostHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
			this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
			this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
			this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
			this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
			this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PreHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
			this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheCounterparty1PostHaircut")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
			this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
			this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
			this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
			return this;
		}
		
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
			this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
			return this;
		}
		
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
			this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
			return this;
		}
		
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
			this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
			return this;
		}
		
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		public CommonCollateralReport build() {
			return new CommonCollateralReport.CommonCollateralReportImpl(this);
		}
		
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUti()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getInitialMarginPostedByTheCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginPostedByTheCounterparty1PostHaircut()!=null) return true;
			if (getInitialMarginPostedByCounterparty1Currency()!=null) return true;
			if (getVariationMarginPostedByTheCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginPostedByTheCounterparty1PostHaircut()!=null) return true;
			if (getVariationMarginPostedByCounterparty1Currency()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1PostHaircut()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1Currency()!=null) return true;
			if (getVariationMarginCollectedByTheCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginCollectedByTheCounterparty1PostHaircut()!=null) return true;
			if (getVariationMarginCollectedByCounterparty1Currency()!=null) return true;
			if (getExcessCollateralPostedByTheCounterparty1()!=null) return true;
			if (getCurrencyOfTheExcessCollateralPosted()!=null) return true;
			if (getExcessCollateralCollectedByTheCounterparty1()!=null) return true;
			if (getCurrencyOfTheExcessCollateralCollected()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonCollateralReport.CommonCollateralReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonCollateralReport.CommonCollateralReportBuilder o = (CommonCollateralReport.CommonCollateralReportBuilder) other;
			
			
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getInitialMarginPostedByTheCounterparty1PreHaircut(), o.getInitialMarginPostedByTheCounterparty1PreHaircut(), this::setInitialMarginPostedByTheCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginPostedByTheCounterparty1PostHaircut(), o.getInitialMarginPostedByTheCounterparty1PostHaircut(), this::setInitialMarginPostedByTheCounterparty1PostHaircut);
			merger.mergeBasic(getInitialMarginPostedByCounterparty1Currency(), o.getInitialMarginPostedByCounterparty1Currency(), this::setInitialMarginPostedByCounterparty1Currency);
			merger.mergeBasic(getVariationMarginPostedByTheCounterparty1PreHaircut(), o.getVariationMarginPostedByTheCounterparty1PreHaircut(), this::setVariationMarginPostedByTheCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginPostedByTheCounterparty1PostHaircut(), o.getVariationMarginPostedByTheCounterparty1PostHaircut(), this::setVariationMarginPostedByTheCounterparty1PostHaircut);
			merger.mergeBasic(getVariationMarginPostedByCounterparty1Currency(), o.getVariationMarginPostedByCounterparty1Currency(), this::setVariationMarginPostedByCounterparty1Currency);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1PreHaircut(), o.getInitialMarginCollectedByCounterparty1PreHaircut(), this::setInitialMarginCollectedByCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1PostHaircut(), o.getInitialMarginCollectedByCounterparty1PostHaircut(), this::setInitialMarginCollectedByCounterparty1PostHaircut);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1Currency(), o.getInitialMarginCollectedByCounterparty1Currency(), this::setInitialMarginCollectedByCounterparty1Currency);
			merger.mergeBasic(getVariationMarginCollectedByTheCounterparty1PreHaircut(), o.getVariationMarginCollectedByTheCounterparty1PreHaircut(), this::setVariationMarginCollectedByTheCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginCollectedByTheCounterparty1PostHaircut(), o.getVariationMarginCollectedByTheCounterparty1PostHaircut(), this::setVariationMarginCollectedByTheCounterparty1PostHaircut);
			merger.mergeBasic(getVariationMarginCollectedByCounterparty1Currency(), o.getVariationMarginCollectedByCounterparty1Currency(), this::setVariationMarginCollectedByCounterparty1Currency);
			merger.mergeBasic(getExcessCollateralPostedByTheCounterparty1(), o.getExcessCollateralPostedByTheCounterparty1(), this::setExcessCollateralPostedByTheCounterparty1);
			merger.mergeBasic(getCurrencyOfTheExcessCollateralPosted(), o.getCurrencyOfTheExcessCollateralPosted(), this::setCurrencyOfTheExcessCollateralPosted);
			merger.mergeBasic(getExcessCollateralCollectedByTheCounterparty1(), o.getExcessCollateralCollectedByTheCounterparty1(), this::setExcessCollateralCollectedByTheCounterparty1);
			merger.mergeBasic(getCurrencyOfTheExcessCollateralCollected(), o.getCurrencyOfTheExcessCollateralCollected(), this::setCurrencyOfTheExcessCollateralCollected);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonCollateralReport _that = getType().cast(o);
		
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(initialMarginPostedByTheCounterparty1PreHaircut, _that.getInitialMarginPostedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheCounterparty1PostHaircut, _that.getInitialMarginPostedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1Currency, _that.getInitialMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginPostedByTheCounterparty1PreHaircut, _that.getVariationMarginPostedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheCounterparty1PostHaircut, _that.getVariationMarginPostedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1Currency, _that.getVariationMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PreHaircut, _that.getInitialMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PostHaircut, _that.getInitialMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1Currency, _that.getInitialMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginCollectedByTheCounterparty1PreHaircut, _that.getVariationMarginCollectedByTheCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheCounterparty1PostHaircut, _that.getVariationMarginCollectedByTheCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1Currency, _that.getVariationMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(excessCollateralPostedByTheCounterparty1, _that.getExcessCollateralPostedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheCounterparty1, _that.getExcessCollateralCollectedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheCounterparty1PreHaircut != null ? initialMarginPostedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheCounterparty1PostHaircut != null ? initialMarginPostedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1Currency != null ? initialMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheCounterparty1PreHaircut != null ? variationMarginPostedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheCounterparty1PostHaircut != null ? variationMarginPostedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1Currency != null ? variationMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PreHaircut != null ? initialMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PostHaircut != null ? initialMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1Currency != null ? initialMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheCounterparty1PreHaircut != null ? variationMarginCollectedByTheCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheCounterparty1PostHaircut != null ? variationMarginCollectedByTheCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1Currency != null ? variationMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheCounterparty1 != null ? excessCollateralPostedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralPosted != null ? currencyOfTheExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheCounterparty1 != null ? excessCollateralCollectedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonCollateralReportBuilder {" +
				"uti=" + this.uti + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"initialMarginPostedByTheCounterparty1PreHaircut=" + this.initialMarginPostedByTheCounterparty1PreHaircut + ", " +
				"initialMarginPostedByTheCounterparty1PostHaircut=" + this.initialMarginPostedByTheCounterparty1PostHaircut + ", " +
				"initialMarginPostedByCounterparty1Currency=" + this.initialMarginPostedByCounterparty1Currency + ", " +
				"variationMarginPostedByTheCounterparty1PreHaircut=" + this.variationMarginPostedByTheCounterparty1PreHaircut + ", " +
				"variationMarginPostedByTheCounterparty1PostHaircut=" + this.variationMarginPostedByTheCounterparty1PostHaircut + ", " +
				"variationMarginPostedByCounterparty1Currency=" + this.variationMarginPostedByCounterparty1Currency + ", " +
				"initialMarginCollectedByCounterparty1PreHaircut=" + this.initialMarginCollectedByCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByCounterparty1PostHaircut=" + this.initialMarginCollectedByCounterparty1PostHaircut + ", " +
				"initialMarginCollectedByCounterparty1Currency=" + this.initialMarginCollectedByCounterparty1Currency + ", " +
				"variationMarginCollectedByTheCounterparty1PreHaircut=" + this.variationMarginCollectedByTheCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByTheCounterparty1PostHaircut=" + this.variationMarginCollectedByTheCounterparty1PostHaircut + ", " +
				"variationMarginCollectedByCounterparty1Currency=" + this.variationMarginCollectedByCounterparty1Currency + ", " +
				"excessCollateralPostedByTheCounterparty1=" + this.excessCollateralPostedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheCounterparty1=" + this.excessCollateralCollectedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"actionType=" + this.actionType + ", " +
				"eventDate=" + this.eventDate +
			'}';
		}
	}
}
