package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.time.ZonedDateTime;


@ImplementedBy(ExtractDateFromDateTime.ExtractDateFromDateTimeDefault.class)
public abstract class ExtractDateFromDateTime implements RosettaFunction {

	/**
	* @param dateTimeInput 
	* @return dateOutput 
	*/
	public Date evaluate(ZonedDateTime dateTimeInput) {
		Date dateOutput = doEvaluate(dateTimeInput);
		
		return dateOutput;
	}

	protected abstract Date doEvaluate(ZonedDateTime dateTimeInput);

	public static class ExtractDateFromDateTimeDefault extends ExtractDateFromDateTime {
		@Override
		protected Date doEvaluate(ZonedDateTime dateTimeInput) {
			Date dateOutput = null;
			return assignOutput(dateOutput, dateTimeInput);
		}
		
		protected Date assignOutput(Date dateOutput, ZonedDateTime dateTimeInput) {
			dateOutput = MapperS.of(dateTimeInput).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get();
			
			return dateOutput;
		}
	}
}
