package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetNameOfTheFloatingRateOfLeg1.GetNameOfTheFloatingRateOfLeg1Default.class)
public abstract class GetNameOfTheFloatingRateOfLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;

	/**
	* @param reportableEvent 
	* @return name 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String name = doEvaluate(reportableEvent);
		
		return name;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	public static class GetNameOfTheFloatingRateOfLeg1Default extends GetNameOfTheFloatingRateOfLeg1 {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String name = null;
			return assignOutput(name, reportableEvent);
		}
		
		protected String assignOutput(String name, ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(reportableEvent));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final FieldWithMetaString fieldWithMetaString = thenArg3
				.mapSingleToItem(item -> MapperS.of(rateOption.evaluate(item.get())).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())).get();
			if (fieldWithMetaString == null) {
				name = null;
			} else {
				name = fieldWithMetaString.getValue();
			}
			
			return name;
		}
	}
}
