package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.BondReference;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.ReferenceObligation;
import cdm.product.template.Basket;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.FilterProductIdentifier;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetUnderlierProductIdentifierLeg2.GetUnderlierProductIdentifierLeg2Default.class)
public abstract class GetUnderlierProductIdentifierLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FilterProductIdentifier filterProductIdentifier;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return productId 
	*/
	public List<? extends ProductIdentifier> evaluate(Product product) {
		List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = doEvaluate(product);
		
		final List<? extends ProductIdentifier> productId;
		if (productIdBuilder == null) {
			productId = null;
		} else {
			productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
			objectValidator.validate(ProductIdentifier.class, productId);
		}
		
		return productId;
	}

	protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product);

	public static class GetUnderlierProductIdentifierLeg2Default extends GetUnderlierProductIdentifierLeg2 {
		@Override
		protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product) {
			List<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<>();
			return assignOutput(productId, product);
		}
		
		protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product) {
			final MapperC<ReferenceObligation> thenArg0;
			if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(false)) {
				thenArg0 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
			} else if (exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(false)) {
				thenArg0 = MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
			} else {
				thenArg0 = MapperC.<ReferenceObligation>ofNull();
			}
			final MapperListOfLists<ReferenceWithMetaProductIdentifier> thenArg1 = thenArg0
				.mapItemToList(item -> {
					if (exists(item.<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(false)) {
						return item.<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
			productId.addAll(toBuilder(thenArg1
				.mapListToItem(item -> MapperS.of(filterProductIdentifier.evaluate(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN))).getMulti()));
			
			final MapperC<ProductIdentifier> thenArg2;
			if (ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product))).and(exists(MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(false)) {
				thenArg2 = MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			} else if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product))).and(exists(MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity2 -> referenceWithMetaCommodity2 == null ? null : referenceWithMetaCommodity2.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(false)) {
				thenArg2 = MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity3 -> referenceWithMetaCommodity3 == null ? null : referenceWithMetaCommodity3.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			} else if (exists(MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier())).getOrDefault(false)) {
				thenArg2 = MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			} else if (exists(MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
				thenArg2 = MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			} else if (exists(MapperS.of(interestRateLeg2.evaluate(product)).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond())).getOrDefault(false)) {
				thenArg2 = MapperC.of(MapperS.of(interestRateLeg2.evaluate(product)).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond()));
			} else {
				thenArg2 = MapperC.<ProductIdentifier>ofNull();
			}
			productId.addAll(toBuilder(thenArg2
				.mapItem(item -> MapperS.of(filterProductIdentifier.evaluate(item.getMulti(), ProductIdTypeEnum.ISIN))).getMulti()));
			
			return Optional.ofNullable(productId)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
