package drr.regulation.common.functions;

import cdm.event.common.ActionEnum;
import cdm.event.common.CounterpartyPositionBusinessEvent;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.position.CounterpartyPosition;
import cdm.event.workflow.WorkflowStep;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.qualification.event.functions.IsActionTypeTERM;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableEvent;
import java.time.LocalDateTime;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsActionTypePositionMODI.IsActionTypePositionMODIDefault.class)
public abstract class IsActionTypePositionMODI implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return isActionTypePositionModi 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypePositionModi = doEvaluate(reportableEvent);
		
		return isActionTypePositionModi;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<Date> openPositionDate(ReportableEvent reportableEvent);

	protected abstract MapperS<Date> eventDate(ReportableEvent reportableEvent);

	public static class IsActionTypePositionMODIDefault extends IsActionTypePositionMODI {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypePositionModi = null;
			return assignOutput(isActionTypePositionModi, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypePositionModi, ReportableEvent reportableEvent) {
			if (areEqual(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction()), MapperS.of(ActionEnum.NEW), CardinalityOperator.All).and(exists(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<CounterpartyPositionBusinessEvent>map("getCounterpartyPositionBusinessEvent", workflowStep -> workflowStep.getCounterpartyPositionBusinessEvent()))).and(lessThan(openPositionDate(reportableEvent), eventDate(reportableEvent), CardinalityOperator.All)).and(areEqual(MapperS.of(isActionTypeTERM.evaluate(reportableEvent)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
				isActionTypePositionModi = true;
			} else {
				isActionTypePositionModi = false;
			}
			
			return isActionTypePositionModi;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
		}
		
		@Override
		protected MapperS<Date> openPositionDate(ReportableEvent reportableEvent) {
			return MapperS.of(distinct(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<CounterpartyPositionBusinessEvent>map("getCounterpartyPositionBusinessEvent", workflowStep -> workflowStep.getCounterpartyPositionBusinessEvent()).<CounterpartyPositionState>mapC("getAfter", counterpartyPositionBusinessEvent -> counterpartyPositionBusinessEvent.getAfter()).<CounterpartyPosition>map("getCounterpartyPosition", counterpartyPositionState -> counterpartyPositionState.getCounterpartyPosition()).<LocalDateTime>map("getOpenDateTime", counterpartyPosition -> counterpartyPosition.getOpenDateTime()).<Date>map("Date", dt -> Date.of(dt.toLocalDate()))).get());
		}
		
		@Override
		protected MapperS<Date> eventDate(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<CounterpartyPositionBusinessEvent>map("getCounterpartyPositionBusinessEvent", workflowStep -> workflowStep.getCounterpartyPositionBusinessEvent()).<Date>map("getEventDate", counterpartyPositionBusinessEvent -> counterpartyPositionBusinessEvent.getEventDate());
		}
	}
}
