package drr.regulation.common.functions;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.qualification.functions.Qualify_BaseProduct_CrossCurrency;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Inflation;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsOption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradeForEvent;
import drr.enrichment.upi.functions.Compute_NotionalScheduleType;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.upi.AnnaDsbNotionalScheduleEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsNotionalScheduleCustom.IsNotionalScheduleCustomDefault.class)
public abstract class IsNotionalScheduleCustom implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Compute_NotionalScheduleType compute_NotionalScheduleType;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
	@Inject protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_BaseProduct_CrossCurrency qualify_BaseProduct_CrossCurrency;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected Qualify_BaseProduct_Inflation qualify_BaseProduct_Inflation;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public AnnaDsbNotionalScheduleEnum evaluate(ReportableEvent reportableEvent) {
		AnnaDsbNotionalScheduleEnum result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract AnnaDsbNotionalScheduleEnum doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbNotionalScheduleEnum> leg1(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbNotionalScheduleEnum> leg2(ReportableEvent reportableEvent);

	public static class IsNotionalScheduleCustomDefault extends IsNotionalScheduleCustom {
		@Override
		protected AnnaDsbNotionalScheduleEnum doEvaluate(ReportableEvent reportableEvent) {
			AnnaDsbNotionalScheduleEnum result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected AnnaDsbNotionalScheduleEnum assignOutput(AnnaDsbNotionalScheduleEnum result, ReportableEvent reportableEvent) {
			if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				final Boolean _boolean = isOption.evaluate(product(reportableEvent).get());
				if ((_boolean == null ? false : _boolean)) {
					result = null;
				} else if (areEqual(leg1(reportableEvent), leg2(reportableEvent), CardinalityOperator.All).getOrDefault(false)) {
					result = leg1(reportableEvent).get();
				} else {
					result = AnnaDsbNotionalScheduleEnum.CUSTOM;
				}
			} else {
				result = null;
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
			return MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get()));
		}
		
		@Override
		protected MapperS<AnnaDsbNotionalScheduleEnum> leg1(ReportableEvent reportableEvent) {
			if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				return MapperS.of(compute_NotionalScheduleType.evaluate(MapperS.of(getLeg1ResolvablePriceQuantity.evaluate(tradeForEvent.evaluate(reportableEvent))).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).getMulti()));
			}
			return MapperS.<AnnaDsbNotionalScheduleEnum>ofNull();
		}
		
		@Override
		protected MapperS<AnnaDsbNotionalScheduleEnum> leg2(ReportableEvent reportableEvent) {
			if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				return MapperS.of(compute_NotionalScheduleType.evaluate(MapperS.of(getLeg2ResolvablePriceQuantity.evaluate(tradeForEvent.evaluate(reportableEvent))).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).getMulti()));
			}
			return MapperS.<AnnaDsbNotionalScheduleEnum>ofNull();
		}
	}
}
